/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment;


/**
 * This class encapsulates information in the runAs-specified-identity
 * XML element as well as the runtime principal to be used.
 *
 * @author Sanjeev Krishnan
 */ 

public final class RunAsIdentityDescriptor extends Descriptor {

    private String roleName="";
    private String principal="";

    public RunAsIdentityDescriptor() 
    {}

    public RunAsIdentityDescriptor(String description) 
    {
	super("no name", description);
    }

    public void setRoleName(String roleName)
    {
	this.roleName = roleName;
    }

    public String getRoleName()
    {
	return roleName;
    }

    public void setPrincipal(String principal)
    {
	this.principal = principal;
    }

    public String getPrincipal()
    {
	return principal;
    }    
}
