/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.web.SecurityRole;
import com.sun.enterprise.deployment.Role;

    /** 
    * I am an abstract role..
    *
    *@author Danny Coward
    */
public class SecurityRoleDescriptor extends Descriptor implements SecurityRole {
    
    /**
    * Construct a SecurityRoleDescriptor from the given role name and description.
    */
    public SecurityRoleDescriptor(String name, String description) {
	super(name, description);
    }
    
    /**
    * Construct a SecurityRoleDescriptor from the given role object.
    */
    
    public SecurityRoleDescriptor(Role role) {
	super(role.getName(), role.getDescription());
    }
    
    /**
    * Default constructor.
    */
    public SecurityRoleDescriptor() {
    }
    
    /**
    * Equality on rolename.
    */
    
    public boolean equals(Object other) {
	if (other instanceof SecurityRoleDescriptor &&
	    this.getName().equals( ((SecurityRoleDescriptor) other).getName() )) {
		return true;
	}
	return false;
    }
    
    /**
    * My hashcode.
    */
    
    public int hashCode() {
	return this.getName().hashCode();
    }
    
    /**
    * Formatted string representing my state.
    */    
    public void print(StringBuffer toStringBuffer) {
	toStringBuffer.append("SecurityRole ");
	super.print(toStringBuffer);
    }

}
