/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.annotation.factory;

import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.annotation.AnnotatedElementHandler;
import com.sun.enterprise.deployment.annotation.context.AppClientContext;
import com.sun.enterprise.deployment.annotation.context.EjbBundleContext;
import com.sun.enterprise.deployment.annotation.context.WebBundleContext;

/**
 * The Factory is reponsible for creating AnnotatedElementHandler.
 *
 * @author Shing Wai Chan
 */
public class AnnotatedElementHandlerFactory {
    private AnnotatedElementHandlerFactory() {
    }

    public static AnnotatedElementHandler createAnnotatedElementHandler(
            BundleDescriptor bundleDesc) {
        AnnotatedElementHandler aeHandler = null;
        if (bundleDesc instanceof EjbBundleDescriptor) {
            EjbBundleDescriptor ejbBundleDesc = (EjbBundleDescriptor)bundleDesc;
            aeHandler = new EjbBundleContext(ejbBundleDesc);
        } else if (bundleDesc instanceof ApplicationClientDescriptor) {
            ApplicationClientDescriptor appClientDesc =
                    (ApplicationClientDescriptor)bundleDesc;
            aeHandler = new AppClientContext(appClientDesc);
        } else if (bundleDesc instanceof WebBundleDescriptor) {
            WebBundleDescriptor webBundleDesc = (WebBundleDescriptor)bundleDesc;
            aeHandler = new WebBundleContext(webBundleDesc);
        }

        return aeHandler;
    }
}
