/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;

import java.util.Set;

import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.Timeout;
import javax.ejb.TransactionManagement;
import javax.ejb.MessageDriven;
import javax.ejb.Stateful;
import javax.ejb.Stateless;

import com.sun.enterprise.util.TypeUtil;
import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;

import com.sun.enterprise.deployment.annotation.AnnotationInfo;
import com.sun.enterprise.deployment.annotation.AnnotatedElementHandler;
import com.sun.enterprise.deployment.annotation.AnnotationProcessorException;
import com.sun.enterprise.deployment.annotation.HandlerProcessingResult;
import com.sun.enterprise.deployment.annotation.context.EjbContext;

/**
 * This handler is responsible for handling the javax.ejb.TransactionAttribute.
 *
 * @author Shing Wai Chan
 */
public class TransactionAttributeHandler extends AbstractAttributeHandler
        implements PostProcessor {
    
    public TransactionAttributeHandler() {
    }
    
    /**
     * @return the annoation type this annotation handler is handling
     */
    public Class<? extends Annotation> getAnnotationType() {
        return TransactionAttribute.class;
    }    
        
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo,
            EjbContext[] ejbContexts) throws AnnotationProcessorException {
        
        TransactionAttribute taAn = 
            (TransactionAttribute) ainfo.getAnnotation();

        for (EjbContext ejbContext : ejbContexts) {
            EjbDescriptor ejbDesc = ejbContext.getDescriptor();
            ContainerTransaction containerTransaction =
                getContainerTransaction(taAn.value());

            if (ElementType.TYPE.equals(ainfo.getElementType())) {
                ejbContext.addPostProcessInfo(ainfo, this);
            } else {
                Method annMethod = (Method) ainfo.getAnnotatedElement();
                
                Set txBusMethods = ejbDesc.getTxBusinessMethodDescriptors();
                for (Object next : txBusMethods) {
                    MethodDescriptor nextDesc = (MethodDescriptor) next;
                    Method m = nextDesc.getMethod(ejbDesc);
                    if( TypeUtil.sameMethodSignature(m, annMethod) &&
                            ejbDesc.getContainerTransactionFor(nextDesc) == null ) {
                        // override by xml
                        ejbDesc.setContainerTransactionFor
                            (nextDesc, containerTransaction);
                    }
                }
            }
        }

        return getDefaultProcessedResult();
    }

    private ContainerTransaction getContainerTransaction(
            TransactionAttributeType taType) {
        switch(taType) {
            case MANDATORY:
                return new ContainerTransaction(
                        ContainerTransaction.MANDATORY,
                        ContainerTransaction.MANDATORY);
            case REQUIRED:
                return new ContainerTransaction(
                        ContainerTransaction.REQUIRED,
                        ContainerTransaction.REQUIRED);
            case REQUIRES_NEW:
                return new ContainerTransaction(
                        ContainerTransaction.REQUIRES_NEW,
                        ContainerTransaction.REQUIRES_NEW);
            case SUPPORTS:
                return new ContainerTransaction(
                        ContainerTransaction.SUPPORTS,
                        ContainerTransaction.SUPPORTS);
            case NOT_SUPPORTED:
                return new ContainerTransaction(
                        ContainerTransaction.NOT_SUPPORTED,
                        ContainerTransaction.NOT_SUPPORTED);
            default: // NEVER
                return new ContainerTransaction(
                        ContainerTransaction.NEVER,
                        ContainerTransaction.NEVER);
        }
    }

    /**
     * @return an array of annotation types this annotation handler would 
     * require to be processed (if present) before it processes it's own 
     * annotation type.
     */
    public Class<? extends Annotation>[] getTypeDependencies() {
        return new Class[] {
            MessageDriven.class, Stateful.class, Stateless.class, 
                Timeout.class, TransactionManagement.class};
                
    }

    protected boolean supportTypeInheritance() {
        return true;
    }

    public void postProcessAnnotation(AnnotationInfo ainfo,
            AnnotatedElementHandler aeHandler)
            throws AnnotationProcessorException {
        EjbContext ejbContext = (EjbContext)aeHandler;
        EjbDescriptor ejbDesc = ejbContext.getDescriptor();
        TransactionAttribute taAn = 
            (TransactionAttribute) ainfo.getAnnotation();
        ContainerTransaction containerTransaction =
            getContainerTransaction(taAn.value());
        Class classAn = (Class)ainfo.getAnnotatedElement();

        Set txBusMethods = ejbDesc.getTxBusinessMethodDescriptors();
        for (Object mdObj : txBusMethods) {
            MethodDescriptor md = (MethodDescriptor)mdObj;
            // override by xml
            if (classAn.equals(ejbContext.getDeclaringClass(md)) &&
                    ejbDesc.getContainerTransactionFor(md) == null) {
                ejbDesc.setContainerTransactionFor(
                    md, containerTransaction);
            }
        }
    }
}
