/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.enterprise.deployment.io.runtime;

import com.sun.enterprise.deployment.*;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;


/**
 * Factory for runtime DeploymentDescriptorFile implementations
 *
 * @author Jerome Dochez
 */
public class RuntimeDDFileFactory {
    
    /** no instance necessary for this factory **/
    private RuntimeDDFileFactory() {
    }
    
    /**
     * Creates and return an appropriate DeploymentDescriptorFile
     * capable of handling the passed descriptor
     *
     * @param descriptor used to identify the associated DeploymentDescriptorFile
     * @return the created DeploymentDescriptorFile
     */
    public static DeploymentDescriptorFile getDDFileFor(RootDeploymentDescriptor descriptor) {
        if (descriptor instanceof Application) {
            return new ApplicationRuntimeDDFile();
        }
        if (descriptor instanceof EjbBundleDescriptor) {
            return new EjbRuntimeDDFile();
        }
        if (descriptor instanceof WebBundleDescriptor) {
            return new WebRuntimeDDFile();
        }
        if (descriptor instanceof ConnectorDescriptor) {
            return new ConnectorRuntimeDDFile();
        } 
        if (descriptor instanceof ApplicationClientDescriptor) {
            return new AppClientRuntimeDDFile();
        }
        return null;
    }
}
    
