/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.node.connector;

import java.util.*;
import org.xml.sax.Attributes;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.OutboundResourceAdapter;
import com.sun.enterprise.deployment.AdminObject;
import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.xml.ConnectorTagNames;
import com.sun.enterprise.deployment.xml.TagNames;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.node.DescriptorFactory;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.ConfigurableNode;
import com.sun.enterprise.deployment.node.XMLElement;

import org.xml.sax.Attributes;
import org.w3c.dom.Node;

/**
 * This node is responsible for handling the Connector DTD related config-property XML tag
 *
 * @author  Sheetal Vartak
 * @version 
 */
public class ConfigPropertyNode extends DeploymentDescriptorNode {

    private EnvironmentProperty config = null;

   /**
     * all sub-implementation of this class can use a dispatch table to map xml element to
     * method name on the descriptor class for setting the element value. 
     *  
     * @return the map with the element name as a key, the setter method as a value
     */    
    protected Map getDispatchTable() {    
        Map table = super.getDispatchTable();
        table.put(ConnectorTagNames.CONFIG_PROPERTY_NAME, "setName");
        table.put(ConnectorTagNames.CONFIG_PROPERTY_VALUE, "setValue");
        table.put(ConnectorTagNames.CONFIG_PROPERTY_TYPE, "setType");        
        return table;
    }    

    /**
    * @return the descriptor instance to associate with this XMLNode
    */    
    public Object getDescriptor() {
        if (config == null) {
            config = (EnvironmentProperty) DescriptorFactory.getDescriptor(getXMLPath());
        } 
        return config;
    } 

    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node for the DOM tree
     * @param the descriptor to write
     * @return the DOM tree top node
     */    
    public Node writeDescriptor(Node parent, Descriptor descriptor) {

        if (! (descriptor instanceof ConnectorDescriptor) && 
	    ! (descriptor instanceof AdminObject) && 
	    ! (descriptor instanceof ConnectionDefDescriptor) &&
	    ! (descriptor instanceof OutboundResourceAdapter)) {
            throw new IllegalArgumentException(getClass() + " cannot handle descriptors of type " + descriptor.getClass());
        }
	Iterator configProps = null;
	if (descriptor instanceof ConnectorDescriptor) {
	    configProps = ((ConnectorDescriptor)descriptor).getConfigProperties().iterator();
	} else if (descriptor instanceof ConnectionDefDescriptor) {
	    configProps = ((ConnectionDefDescriptor)descriptor).getConfigProperties().iterator();
	} else if (descriptor instanceof AdminObject) {
	    configProps = ((AdminObject)descriptor).getConfigProperties().iterator();
	} else if (descriptor instanceof OutboundResourceAdapter) {
	    configProps = ((OutboundResourceAdapter)descriptor).getConfigProperties().iterator();
	}
	//config property info
	for (;configProps.hasNext();) {
	    EnvironmentProperty config = (EnvironmentProperty) configProps.next();
	    Node configNode = appendChild(parent, ConnectorTagNames.CONFIG_PROPERTY);
	    writeLocalizedDescriptions(configNode, config);  
	    appendTextChild(configNode, ConnectorTagNames.CONFIG_PROPERTY_NAME, config.getName());  
	    appendTextChild(configNode, ConnectorTagNames.CONFIG_PROPERTY_TYPE, config.getType());  
	    appendTextChild(configNode, ConnectorTagNames.CONFIG_PROPERTY_VALUE, config.getValue());  
	}
	return parent;
    }
}
