/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment.node.ejb;

import java.util.Map;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.LocalizedInfoNode;
import com.sun.enterprise.deployment.node.MethodNode;
import com.sun.enterprise.deployment.node.DescriptorFactory;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbApplicationExceptionInfo;

import com.sun.enterprise.deployment.xml.EjbTagNames;

public class EjbApplicationExceptionNode extends DeploymentDescriptorNode {

    public EjbApplicationExceptionNode() {
       super();
    }
        
    /**
     * all sub-implementation of this class can use a dispatch table to map xml element to
     * method name on the descriptor class for setting the element value. 
     *  
     * @return the map with the element name as a key, the setter method as a value
     */    
    protected Map getDispatchTable() {
        // no need to be synchronized for now
        Map table = super.getDispatchTable();

        table.put(EjbTagNames.APP_EXCEPTION_CLASS, "setExceptionClassName");
        table.put(EjbTagNames.APP_EXCEPTION_ROLLBACK, "setRollback");

        return table;
    }    

   /**
     * write the application exception info to a DOM tree and return it
     *
     * @param parent node in the DOM tree 
     * @param node name for the root element of this xml fragment      
     * @param the descriptor to write
     * @return the DOM tree top node
     */
    public Node writeDescriptor(Node parent, String nodeName, 
                                EjbApplicationExceptionInfo descriptor) {

        Node appExceptionNode = appendChild(parent, nodeName);
        
        appendTextChild(appExceptionNode, EjbTagNames.APP_EXCEPTION_CLASS,
                        descriptor.getExceptionClassName());
        appendTextChild(appExceptionNode, EjbTagNames.APP_EXCEPTION_ROLLBACK,
                        Boolean.toString(descriptor.getRollback()));

        return appExceptionNode;
    }
}
