/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment.node.runtime;

import java.util.Map;
import org.w3c.dom.Node;

import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.runtime.MdbConnectionFactoryDescriptor;
import com.sun.enterprise.deployment.ResourcePrincipal;
import com.sun.enterprise.deployment.xml.RuntimeTagNames;

public class MDBConnectionFactoryNode extends DeploymentDescriptorNode {
    
    protected MdbConnectionFactoryDescriptor descriptor;
    
    public MDBConnectionFactoryNode() {
	registerElementHandler(new XMLElement(RuntimeTagNames.DEFAULT_RESOURCE_PRINCIPAL), DefaultResourcePrincipalNode.class);
    }
    
    
   /**
    * @return the descriptor instance to associate with this XMLNode
    */    
    public Object getDescriptor() {
	if (descriptor==null) {
	    descriptor = new MdbConnectionFactoryDescriptor();
	} 
	return descriptor;
    }
    
    /**
     * all sub-implementation of this class can use a dispatch table to map xml element to
     * method name on the descriptor class for setting the element value. 
     *  
     * @return the map with the element name as a key, the setter method as a value
     */    
    protected Map getDispatchTable() {  
	Map dispatchTable = super.getDispatchTable();
	dispatchTable.put(RuntimeTagNames.JNDI_NAME, "setJndiName");
	return dispatchTable;
    }
    
    /**
     * Adds  a new DOL descriptor instance to the descriptor instance associated with 
     * this XMLNode
     *
     * @param descriptor the new descriptor
     */
    public void addDescriptor(Object newDescriptor) {
	if (newDescriptor instanceof ResourcePrincipal) {
	    descriptor.setDefaultResourcePrincipal((ResourcePrincipal) newDescriptor);
	} else super.addDescriptor(newDescriptor);
    }
    
    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node for the DOM tree
     * @param node name for the descriptor
     * @param the descriptor to write
     * @return the DOM tree top node
     */    
    public Node writeDescriptor(Node parent, String nodeName, MdbConnectionFactoryDescriptor mcf) {    
	Node mcfNode = super.writeDescriptor(parent, nodeName, mcf);
	appendTextChild(mcfNode, RuntimeTagNames.JNDI_NAME, mcf.getJndiName());
        if (mcf.getDefaultResourcePrincipal()!=null) {
            DefaultResourcePrincipalNode subNode = new DefaultResourcePrincipalNode();
            subNode.writeDescriptor(mcfNode, RuntimeTagNames.DEFAULT_RESOURCE_PRINCIPAL, mcf.getDefaultResourcePrincipal());
        }
	return mcfNode;
    }
}
