/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.node.runtime.common;

import java.util.ArrayList;
import java.util.Iterator;

import org.w3c.dom.Node;

import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.xml.WebServicesTagNames;
import com.sun.enterprise.deployment.runtime.common.ProtectionDescriptor;
import com.sun.enterprise.deployment.runtime.common.MessageDescriptor;
import com.sun.enterprise.deployment.runtime.common.MessageSecurityDescriptor;

/**
 * This node handles message-security element
 *
 */
public class MessageSecurityNode extends DeploymentDescriptorNode {

    MessageSecurityDescriptor descriptor = null;

    public MessageSecurityNode() {
        registerElementHandler(new XMLElement(
            WebServicesTagNames.MESSAGE), MessageNode.class, 
            "addMessageDescriptor");
        registerElementHandler(new XMLElement(
            WebServicesTagNames.REQUEST_PROTECTION), ProtectionNode.class, 
            "setRequestProtectionDescriptor");
        registerElementHandler(new XMLElement(
            WebServicesTagNames.RESPONSE_PROTECTION), ProtectionNode.class, 
            "setResponseProtectionDescriptor");
    }
    
    /**
    * @return the descriptor instance to associate with this XMLNode
    */    
    public Object getDescriptor() {
       if (descriptor == null) {
            descriptor = new MessageSecurityDescriptor();
        }
        return descriptor;
    }     

    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node for the DOM tree
     * @param node name for 
     * @param the descriptor to write
     * @return the DOM tree top node
     */    
    public Node writeDescriptor(Node parent, String nodeName, 
        MessageSecurityDescriptor messageSecurityDesc) {    
        Node messageSecurityNode = super.writeDescriptor(parent, nodeName,
           messageSecurityDesc);

        ArrayList messageDescs =
            messageSecurityDesc.getMessageDescriptors();
        if (!messageDescs.isEmpty()) {
            MessageNode messageNode = new MessageNode();
            for (Iterator messageIterator = messageDescs.iterator();
                messageIterator.hasNext();) {
                MessageDescriptor messageDesc =
                    (MessageDescriptor) messageIterator.next();
                messageNode.writeDescriptor(messageSecurityNode,
                    WebServicesTagNames.MESSAGE, messageDesc);
            }
        }

        // request-protection
        ProtectionDescriptor requestProtectionDesc = 
            messageSecurityDesc.getRequestProtectionDescriptor();
        if (requestProtectionDesc != null) {
            ProtectionNode requestProtectionNode = new ProtectionNode();
            requestProtectionNode.writeDescriptor(messageSecurityNode,
                WebServicesTagNames.REQUEST_PROTECTION, requestProtectionDesc);
        }

        // response-protection
        ProtectionDescriptor responseProtectionDesc = 
            messageSecurityDesc.getResponseProtectionDescriptor();
        if (responseProtectionDesc != null) {
            ProtectionNode responseProtectionNode = new ProtectionNode();
            responseProtectionNode.writeDescriptor(messageSecurityNode,
                WebServicesTagNames.RESPONSE_PROTECTION, 
                    responseProtectionDesc);
        }

        return messageSecurityNode;
    }
}
