/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment.node.runtime.connector;

import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.runtime.RuntimeBundleNode;
import com.sun.enterprise.deployment.runtime.connector.SunConnector;
import com.sun.enterprise.deployment.runtime.connector.ResourceAdapter;
import com.sun.enterprise.deployment.runtime.connector.RoleMap;
import com.sun.enterprise.deployment.xml.RuntimeTagNames;
import com.sun.enterprise.deployment.xml.DTDRegistry;

/**
 * This node handles the sun-connector runtime deployment descriptors 
 *
 * @author  Jerome Dochez
 * @version 
 */
public class ConnectorNode extends RuntimeBundleNode {

    protected SunConnector descriptor=null;
    protected ConnectorDescriptor connector=null;
    /**
     * Initialize the child handlers
     */
    public ConnectorNode(ConnectorDescriptor connector) {
        
        // we do not care about our standard DDS handles
        handlers = null;
        
	this.connector = connector;
	
        registerElementHandler(new XMLElement(RuntimeTagNames.RESOURCE_ADAPTER), 
                               ResourceAdapterNode.class, "setResourceAdapter");
        registerElementHandler(new XMLElement(RuntimeTagNames.ROLE_MAP), 
                               RoleMapNode.class,"setRoleMap"); 
    }
    
    /** 
     * @return the DOCTYPE that should be written to the XML file
     */
    public String getDocType() {
	return DTDRegistry.SUN_CONNECTOR_100_DTD_PUBLIC_ID;
    }
    
    /**
     * @return the SystemID of the XML file
     */
    public String getSystemID() {
	return DTDRegistry.SUN_CONNECTOR_100_DTD_SYSTEM_ID;
    }

    /**
     * @return NULL for all runtime nodes.
     */
    public List<String> getSystemIDs() {
        return null;
    }
    
    protected XMLElement getXMLRootTag() {
        return new XMLElement(RuntimeTagNames.S1AS_CONNECTOR_RUNTIME_TAG);
    }      
    
   /**
    * register this node as a root node capable of loading entire DD files
    * 
    * @param publicIDToDTD is a mapping between xml Public-ID to DTD 
    * @return the doctype tag name
    */
   public static String registerBundle(Map publicIDToDTD) {    
       publicIDToDTD.put(DTDRegistry.SUN_CONNECTOR_100_DTD_PUBLIC_ID, DTDRegistry.SUN_CONNECTOR_100_DTD_SYSTEM_ID);
       return RuntimeTagNames.S1AS_CONNECTOR_RUNTIME_TAG;
   } 
   
   /**
    * @return the descriptor instance to associate with this XMLNode
    */    
    public Object getDescriptor() {
        if (descriptor==null) {
	    descriptor = new SunConnector();
            connector.setSunDescriptor(descriptor);
	}
        return descriptor;
    }
    
    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node for the DOM tree
     * @param node name for the descriptor
     * @param the descriptor to write
     * @return the DOM tree top node
     */    
    public Node writeDescriptor(Node parent, String nodeName, Descriptor descriptor) {
        if (!(descriptor instanceof ConnectorDescriptor)) {
            throw new IllegalArgumentException(getClass() + " cannot handles descriptors of type " + descriptor.getClass());
        }
        ConnectorDescriptor connector = (ConnectorDescriptor) descriptor;
            
	Node connectorNode = super.writeDescriptor(parent, nodeName, descriptor);
	
	// resource-adapter
        SunConnector sunDesc = connector.getSunDescriptor();
        if (sunDesc!=null) {
            ResourceAdapterNode ran = new ResourceAdapterNode();
            ran.writeDescriptor(connectorNode, RuntimeTagNames.RESOURCE_ADAPTER, sunDesc.getResourceAdapter());
	
            // role-map ?
            if (sunDesc.getRoleMap()!=null) {
                RoleMapNode rmn = new RoleMapNode();
                rmn.writeDescriptor(connectorNode, RuntimeTagNames.ROLE_MAP, sunDesc.getRoleMap());
            }
        }
	return connectorNode;
    }
}
