/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment.node.runtime.connector;

import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.Element;

import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.runtime.RuntimeDescriptorNode;
import com.sun.enterprise.deployment.runtime.connector.RoleMap;
import com.sun.enterprise.deployment.runtime.connector.MapElement;
import com.sun.enterprise.deployment.xml.RuntimeTagNames;

/**
 * This node handles the role-map runtime deployment descriptors 
 *
 * @author  Jerome Dochez
 * @version 
 */
public class RoleMapNode extends RuntimeDescriptorNode {
    
    
    public RoleMapNode() {
        registerElementHandler(new XMLElement(RuntimeTagNames.MAP_ELEMENT), 
                               MapElementNode.class, "addMapElement"); 
    }
    
    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node for the DOM tree
     * @param node name for the descriptor
     * @param the descriptor to write
     * @return the DOM tree top node
     */    
    public Node writeDescriptor(Node parent, String nodeName, RoleMap descriptor) {
	Element roleMapNode = (Element) super.writeDescriptor(parent, nodeName, descriptor);
	appendTextChild(roleMapNode, RuntimeTagNames.DESCRIPTION, descriptor.getDescription());
	setAttribute(roleMapNode, RuntimeTagNames.MAP_ID, (String) descriptor.getValue(RoleMap.MAP_ID));

	// map-element*
	MapElement[] maps = descriptor.getMapElement();	
	if (maps.length>0) {
	    MapElementNode men = new MapElementNode();
	    for (int i=0;i<maps.length;i++) {
		men.writeDescriptor(roleMapNode, RuntimeTagNames.MAP_ELEMENT, maps[i]);
	    }
	}
	
	return roleMapNode;
    }
}
