/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.node.runtime.web;

import java.util.Map;
import org.xml.sax.Attributes;
import org.w3c.dom.Node;
import org.w3c.dom.Element;

import com.sun.enterprise.deployment.runtime.RuntimeDescriptor;
import com.sun.enterprise.deployment.runtime.web.CacheMapping;
import com.sun.enterprise.deployment.runtime.web.ConstraintField;
import com.sun.enterprise.deployment.xml.RuntimeTagNames;
import com.sun.enterprise.deployment.node.XMLElement;

/**
* node for cache-mapping tag
*
* @author Jerome Dochez
*/
public class CacheMappingNode extends WebRuntimeNode {
    
    public CacheMappingNode() {
	
        registerElementHandler(new XMLElement(RuntimeTagNames.CONSTRAINT_FIELD), 
                               ConstraintFieldNode.class, "addNewConstraintField"); 			       
    }
        
    /**
     * all sub-implementation of this class can use a dispatch table to map xml element to
     * method name on the descriptor class for setting the element value. 
     *  
     * @return the map with the element name as a key, the setter method as a value
     */
    protected Map getDispatchTable() {    
	Map dispatchTable = super.getDispatchTable();
	dispatchTable.put(RuntimeTagNames.SERVLET_NAME, "setServletName");
	dispatchTable.put(RuntimeTagNames.URL_PATTERN, "setUrlPattern");
	dispatchTable.put(RuntimeTagNames.CACHE_HELPER_REF, "setCacheHelperRef");	
	dispatchTable.put(RuntimeTagNames.TIMEOUT, "setTimeout");
	dispatchTable.put(RuntimeTagNames.HTTP_METHOD, "addNewHttpMethod");	
	dispatchTable.put(RuntimeTagNames.DISPATCHER, "addNewDispatcher");	
	return dispatchTable;
    }

    public void startElement(XMLElement element, Attributes attributes) {
        CacheMapping descriptor = (CacheMapping) getRuntimeDescriptor();
	if (descriptor==null) {
	    throw new RuntimeException("Trying to set values on a null descriptor");
	} 	
	if (element.getQName().equals(RuntimeTagNames.TIMEOUT)) {
            for (int i=0; i<attributes.getLength();i++) {
                if (RuntimeTagNames.NAME.equals(attributes.getQName(i))) {
		    descriptor.setAttributeValue(CacheMapping.TIMEOUT, CacheMapping.NAME, attributes.getValue(i));
                } else 
                if (RuntimeTagNames.SCOPE.equals(attributes.getQName(i))) {
                    int index=0;
                    while (descriptor.getAttributeValue(CacheMapping.TIMEOUT, index, CacheMapping.NAME)!=null) {
                        index++;
                    }
		    descriptor.setAttributeValue(CacheMapping.TIMEOUT, index-1, CacheMapping.SCOPE, attributes.getValue(i));
	        }  
            }
 	} else 
	if (element.getQName().equals(RuntimeTagNames.REFRESH_FIELD)) {
	    descriptor.setRefreshField(true);
            for (int i=0; i<attributes.getLength();i++) {
	        if (RuntimeTagNames.NAME.equals(attributes.getQName(i))) {
		    descriptor.setAttributeValue(CacheMapping.REFRESH_FIELD, 0, CacheMapping.NAME, attributes.getValue(i));
	        } else
	        if (RuntimeTagNames.SCOPE.equals(attributes.getQName(i))) { 
                    descriptor.setAttributeValue(CacheMapping.REFRESH_FIELD, 0, CacheMapping.SCOPE, attributes.getValue(i));
                }
	    }  
	} else
	if (element.getQName().equals(RuntimeTagNames.KEY_FIELD)) {
	    descriptor.addKeyField(true);
            for (int i=0; i<attributes.getLength();i++) {
                if (RuntimeTagNames.NAME.equals(attributes.getQName(i))) {
		    descriptor.setAttributeValue(CacheMapping.KEY_FIELD, CacheMapping.NAME, attributes.getValue(i));
	        } else
                if (RuntimeTagNames.SCOPE.equals(attributes.getQName(i))) {
                    int index = descriptor.sizeKeyField();               
	            descriptor.setAttributeValue(CacheMapping.KEY_FIELD, index-1, CacheMapping.SCOPE, attributes.getValue(i));
	        } 
            }
	} else super.startElement(element, attributes);
    }
    
    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node for the DOM tree
     * @param node name 
     * @param the descriptor to write
     * @return the DOM tree top node
     */    
    public Node writeDescriptor(Node parent, String nodeName, CacheMapping descriptor) { 
	Node cacheMapping = super.writeDescriptor(parent, nodeName, descriptor);
	if (descriptor.getServletName()!=null) {
	    appendTextChild(cacheMapping, RuntimeTagNames.SERVLET_NAME, descriptor.getServletName());
	} else {
	    appendTextChild(cacheMapping, RuntimeTagNames.URL_PATTERN, descriptor.getUrlPattern());
	}
	
	// cache-helper-ref 
	appendTextChild(cacheMapping, RuntimeTagNames.CACHE_HELPER_REF, 
			(String) descriptor.getValue(CacheMapping.CACHE_HELPER_REF));
	
	//dispatcher* 
	String[] dispatchers = descriptor.getDispatcher();
	if (dispatchers!=null) {
	    for (int i=0;i<dispatchers.length;i++) {
		appendTextChild(cacheMapping, RuntimeTagNames.DISPATCHER, dispatchers[i]);
	    }
	}

	// timeout?
	Element timeout = (Element) forceAppendTextChild(cacheMapping, RuntimeTagNames.TIMEOUT, 
			(String) descriptor.getValue(CacheMapping.TIMEOUT));
        // timeout attributes
        String name = descriptor.getAttributeValue(CacheMapping.TIMEOUT, CacheMapping.NAME);
        if (name!=null) {
            setAttribute(timeout, RuntimeTagNames.NAME, name);
        }
        String scope = descriptor.getAttributeValue(CacheMapping.TIMEOUT, CacheMapping.SCOPE);
        if (scope!=null) {
            setAttribute(timeout, RuntimeTagNames.SCOPE, scope);
        }
	
        //refresh-field?, 
	if (descriptor.isRefreshField()) {
	    Element refreshField = (Element) appendChild(cacheMapping, RuntimeTagNames.REFRESH_FIELD);
	    setAttribute(refreshField, RuntimeTagNames.NAME, 
			(String) descriptor.getAttributeValue(CacheMapping.REFRESH_FIELD, CacheMapping.NAME));
	    setAttribute(refreshField, RuntimeTagNames.SCOPE, 
			(String) descriptor.getAttributeValue(CacheMapping.REFRESH_FIELD, CacheMapping.SCOPE));
	}
	
	//http-method* 
	String[] httpMethods = descriptor.getHttpMethod();
	if (httpMethods!=null) {
	    for (int i=0;i<httpMethods.length;i++) {
		appendTextChild(cacheMapping, RuntimeTagNames.HTTP_METHOD, httpMethods[i]);
	    }
	}
	
	//key-field*
	if (descriptor.sizeKeyField()>0) {
	    for (int i=0;i<descriptor.sizeKeyField();i++) {
		
		if (descriptor.isKeyField(i)) {
		    Element keyField = (Element) appendChild(cacheMapping, RuntimeTagNames.KEY_FIELD);
		    setAttribute(keyField, RuntimeTagNames.NAME, 
			(String) descriptor.getAttributeValue(CacheMapping.KEY_FIELD, i, CacheMapping.NAME));
		    setAttribute(keyField, RuntimeTagNames.SCOPE, 
			(String) descriptor.getAttributeValue(CacheMapping.KEY_FIELD, i, CacheMapping.SCOPE));
		}
	    }
	}
	
	//constraint-field*
	if (descriptor.sizeConstraintField()>0) {
            ConstraintField[] constraintFields = descriptor.getConstraintField();
            ConstraintFieldNode cfn = new ConstraintFieldNode();
	    cfn.writeDescriptor(cacheMapping, RuntimeTagNames.CONSTRAINT_FIELD, constraintFields);
	}
	
	return cacheMapping;
    }	
}
