/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.node.runtime.web;

import org.w3c.dom.Node;
import org.w3c.dom.Element;

import com.sun.enterprise.deployment.xml.RuntimeTagNames;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.runtime.web.IdempotentUrlPattern;



/**
* node to handle idempotent-url-pattern node
*/
public class IdempotentUrlPatternNode extends WebRuntimeNode {

    IdempotentUrlPattern descriptor = null;

    /**
    * @return the descriptor instance to associate with this XMLNode
    */
    public Object getDescriptor() {
        if (descriptor == null) {
            descriptor = new IdempotentUrlPattern();
        }
        return descriptor;
    }

    /**
     * parsed an attribute of an element
     *
     * @param the element name
     * @param the attribute name
     * @param the attribute value
     * @return true if the attribute was processed
     */
    protected boolean setAttributeValue(XMLElement elementName, XMLElement attributeName, String value) {
        if (attributeName.getQName().equals(RuntimeTagNames.URL_PATTERN)) {
            descriptor.setAttributeValue(IdempotentUrlPattern.URL_PATTERN, 
                value);
            return true;
        } else if (attributeName.getQName().equals(
            RuntimeTagNames.NUM_OF_RETRIES)) {
            descriptor.setAttributeValue(IdempotentUrlPattern.NUM_OF_RETRIES,
                value);
            return true;
        }
        return false;
    }
    
    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node for the DOM tree
     * @param node name for the descriptor
     * @param the descriptor to write
     * @return the DOM tree top node
     */    
    public Node writeDescriptor(Node parent, String nodeName, 
       IdempotentUrlPattern pattern) {
       Element patternNode = 
            (Element)super.writeDescriptor(parent, nodeName, pattern);
        
        // url-pattern
        if (pattern.getAttributeValue(pattern.URL_PATTERN) != null) {
            setAttribute(patternNode, RuntimeTagNames.URL_PATTERN, pattern.getAttributeValue(pattern.URL_PATTERN));
        }   

        // num-of-retries
        if (pattern.getAttributeValue(pattern.NUM_OF_RETRIES) != null) {
            setAttribute(patternNode, RuntimeTagNames.NUM_OF_RETRIES, pattern.getAttributeValue(pattern.NUM_OF_RETRIES));
        }

        return patternNode;
    }
}

