/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.runtime.common;

import com.sun.enterprise.deployment.Descriptor;
import java.lang.reflect.Constructor;
import java.security.Principal;

/**
 * This is an in memory representation of the principal-name with its name of 
 * the implementation class.
 * @author deployment dev team
 */
public class PrincipalNameDescriptor extends Descriptor {

    private static final String defaultClassName =
                "com.sun.enterprise.deployment.PrincipalImpl";
    private String principalName = null;
    private String className = null;

    public PrincipalNameDescriptor() {}

    public String getName() {
        return principalName;
    }

    public String getClassName() {
        if (className == null) {
            return defaultClassName;
        }
        return className;
    }

    public void setName(String name) {
        principalName = name;
    }

    public void setClassName(String name) {
        className = name;
    }

    public Principal getPrincipal() {
        try {
            Class clazz = Class.forName(getClassName());
            Constructor constructor = 
                            clazz.getConstructor(new Class[]{String.class});
            Object o = constructor.newInstance(new Object[]{principalName});
            return (Principal) o;
        } catch(Exception ex) {
            RuntimeException e = new RuntimeException();
            e.initCause(ex);
            throw e;
        }
    }

    public String toString() {
        return "principal-name " + principalName + "; className " + getClassName();
    }
}
