/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.types;

import com.sun.enterprise.deployment.web.ContextParameter;

import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.InjectionCapable;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;

/** 
 * Protocol associated with defining an EJB Interface
 *
 * @author Jerome Dochez
 */

public interface EjbReference  extends NamedInformation, InjectionCapable {
    
    /** 
     * Get the type of the EJB (Session, Entity or Message-Driven). 
     * @return the type of the EJB.
     */
    public String getType();

    /**
     * Set the type of the EJB. Allowed values are Session, Entity or
     * Message-driven.
     * @param the type of the EJB.
     */
    public void setType(String type);

    /** 
     * Gets the home classname of the referee EJB. 
     * @return the class name of the EJB home.
     */
    public String getEjbHomeInterface();

    /** 
     * Sets the local or remote home classname of the referee EJB. 
     * @param the class name of the EJB home.
     */
    public void setEjbHomeInterface(String ejbHomeInterface);

    /** 
     * Gets the local or remote interface classname of the referee EJB. 
     * @return the classname of the EJB remote object.
     */
    public String getEjbInterface();

    /** 
     * Sets the local or remote bean interface classname of the referee EJB. 
     * @param the classname of the EJB remote object.
     */
    public void setEjbInterface(String ejbInterface);
    
    /** 
     * Gets the link name of the reference. For use when linking to an EJB 
     * within a J2EE application. 
     * @return the link name.
     */
    public String getLinkName();

    /** 
     * Sets the link name of the reference. For use when linking to an EJB 
     * within a J2EE application. 
     * @param the link name.
     */
    public void setLinkName(String linkName);
    
    /**
     * Tests if the reference to the referree EJB is through local or 
     * remote interface
     * @return true if using the local interfaces
     */
    public boolean isLocal();
    
    /**
     * Sets whether the reference uses the local or remote interfaces of 
     * the referring EJB
     * @param true if using the local interface
     */
    public void setLocal(boolean isLocal);
 
    /**
     * Set the referring bundle, i.e. the bundle within which this
     * EJB reference is declared. 
     */
    public void setReferringBundleDescriptor(BundleDescriptor referringBundle);

    /**
     * Get the referring bundle, i.e. the bundle within which this
     * EJB reference is declared.  
     */
    public BundleDescriptor getReferringBundleDescriptor();
    
    /**
     * Set the jndi name for this ejb reference
     */
    public void setJndiName(String jndiName);
    
    /**
     * @return the jndi name for this ejb reference
     */
    public String getJndiName();
    
    public EjbDescriptor getEjbDescriptor();
    public void setEjbDescriptor(EjbDescriptor descriptor);

    /**
     * @return true if the EJB reference is a 30 client view
     */
    public boolean isEJB30ClientView();

}

