/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.types;

import com.sun.enterprise.deployment.InjectionCapable;
import com.sun.enterprise.deployment.BundleDescriptor;

/** 
 * Protocol associated with defining an EntityManagerFactory reference
 *
 */
public interface EntityManagerFactoryReference extends NamedInformation, 
    InjectionCapable {

    /**
     * Set the unit name of the entity manager factory to which this
     * reference is associated.
     */
    public void setUnitName(String unitName);


    /**
     * Get the unit name of the entity manager factory to which this
     * reference is associated.
     */
    public String getUnitName();

    /**
     * Set the referring bundle, i.e. the bundle within which this
     * reference is declared. 
     */
    public void setReferringBundleDescriptor(BundleDescriptor referringBundle);

    /**
     * Get the referring bundle, i.e. the bundle within which this
     * reference is declared.  
     */
    public BundleDescriptor getReferringBundleDescriptor();


}

