/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.types;

import java.util.Set;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;

/**
 * This interface defines the behaviour of a Java EE component containaing 
 * web service references
 * Note from the author, I hate being so verbose with method names but 
 * I follow the current design pattern. should be fixed one day
 *
 * @author Jerome Dochez
 */
public interface ServiceReferenceContainer {
    
    /** 
     * get a particular service reference by name
     */
    public ServiceReferenceDescriptor getServiceReferenceByName(String name);
    
    /** 
     * return the list of service references
     */
    public Set getServiceReferenceDescriptors();
    
    /**
     * Add a new service reference
     */
    public void addServiceReferenceDescriptor(ServiceReferenceDescriptor descriptor);
    
    /**
     * remove a service reference
     */
    public void removeServiceReferenceDescriptor(ServiceReferenceDescriptor descriptor);
}
