/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.util.webservice;

/**
 * This class is used by the deployment tool to set the required information for jaxrpc-config.xml
 * that is passed as an argument to the wscompile tool. This class is to be used when the developer is
 * using the deploytool to generate SEI from WSDL
 */

public class WSDLConfig {

    private String webServiceName;
    private String wsdlLocation;
    private String packageName;

    /**
     * Constructor takes all required arguments and sets them appropriately
     * @param wsName  Name of the webservice
     * @param wsdl    the WSDL file location
     * @param pkg     the package name where the SEI and its implementations are present
     */
    
    public WSDLConfig(String wsName, String wsdl, String pkg) {
        this.webServiceName = wsName;
        this.wsdlLocation = wsdl;
        this.packageName = pkg;
    }
    
    public String getWebServiceName() { return this.webServiceName; }
    
    public String getWsdlLocation() { return this.wsdlLocation; }
    
    public String getPackageName() { return this.packageName; }
}
