/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.util;

import java.util.Properties;
import java.util.Enumeration;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.*;

//START OF IASRI 4660742
import java.util.logging.*;
import com.sun.logging.*;
//END OF IASRI 4660742


/** 
 * This class lets the developers trigger the debug information 
 * at Runtime.
 * <BR>
 * <P>Any class that intends to use this feature needs to have a 
 * public static boolean variable called "debug".
 * This variable can be triggered to true or false at runtime
 * by having a properties file with the keys as the fully qualified
 * name of classes and the values to be the boolean value the debug
 * variable.
 * <BR>
 */
public final class DebugController {

    // START OF IASRI 4660742
    static Logger _logger=LogDomains.getLogger(LogDomains.UTIL_LOGGER);
    // END OF IASRI 4660742

    private static final String PROPS_FILENAME = "debug.properties";
    private static final String FIELD_NAME = "debug";

    private static DebugController controller = null;

    private Properties props = new Properties();
    private String propsFileName;

    private static DebugController getInstance() {
	if(controller == null) {
	    synchronized(DebugController.class) {
		controller = new DebugController();
	    }
	}
	
	return controller;
    }

    public static void init() {
	DebugController ctrller = getInstance();
	ctrller.load();
    }

    private DebugController() {
	this(PROPS_FILENAME);
    }

    private DebugController(String propsFileName) {
	this.propsFileName = propsFileName;
    }

    private void load() {
	try {
	    FileInputStream fin = new FileInputStream(propsFileName);
	    props.load(fin);
	    
	    for(Enumeration e = props.propertyNames(); e.hasMoreElements(); ) {
		String className = (String) e.nextElement();
		boolean value =
		    Boolean.valueOf(props.getProperty(className)).booleanValue();
		setInfo(className, value);
	    }
	    fin.close();
	} catch(IOException e) {
	    /** IASRI 4660742
       e.printStackTrace(); 
      **/
	    // START OF IASRI 4660742
	     _logger.log(Level.SEVERE,"enterprise_util.dbgcntl_ioexception",e);
	    // END OF IASRI 4660742
	}
    }

    private void setInfo(String className, boolean value) {
	try {
	    Class cls = Class.forName(className);
	    Field dField = cls.getField(FIELD_NAME);
	    dField.setBoolean(null, value);
	} catch (Exception e) {
	    // If there is an exception lets ingore it, there's nothing
	    // we can do about it.
	    /** IASRI 4660742
	    // System.err.println("Debug Controller: " + e.getMessage());
	    // e.printStackTrace();
      **/
	    // START OF IASRI 4660742
      // if(_logger.isLoggable(Level.FINE))
	    //    _logger.log(Level.FINE,"Debug Controller: " + e.getMessage());
	    // _logger.log(Level.SEVERE,"enterprise_util.excep_in_dbgcntl_setInfo",e);
	    // END OF IASRI 4660742
      
	}
    }
} 





