/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.util;

/**
 * Based on Concurrent Programming in Java, Second Edition,
 * by Doug Lea, page 222
 *
 */

public abstract class PoolBase implements Pool {

    private final Semaphore available_;
    private int numItems_;

    protected PoolBase(int numItems) {
        numItems_  = numItems;
        available_ = new SemaphoreImpl(numItems);
    }

    public void initialize() throws Exception {
        doInitializeItems(numItems_);
    }
    
    public Object getItem() throws InterruptedException {
        available_.acquire();
        return doGet();
    }
 
    public void returnItem(Object o) {
        if( doReturn(o) ) {
            available_.release();
        }
    }

    protected abstract Object doGet();
    protected abstract boolean doReturn(Object object);
    protected abstract void doInitializeItems(int numItems) throws Exception;

}
