/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.util;

/**
 * Based on Concurrent Programming in Java, Second Edition,
 * by Doug Lea, page 266
 *
 */

public class SemaphoreImpl implements Semaphore {

    private long numPermits_;

    public SemaphoreImpl(long initialPermits) {
        numPermits_ = initialPermits;
    }

    public synchronized void release() {
        numPermits_++;
        notify();
    }

    public void acquire() throws InterruptedException {
        if( Thread.interrupted()) {
            throw new InterruptedException();
        }
        
        synchronized (this) {
            try {
                while( numPermits_ <= 0 ) {
                    wait();
                } 
                numPermits_--;
            } catch( InterruptedException ie) {
                notify();
                throw ie;
            }
        }
    }

}
