/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.iplanet.ias.security.auth.login;

import com.sun.appserv.security.AppservPasswordLoginModule;
import com.sun.enterprise.security.auth.AuthenticationStatus;
import com.sun.enterprise.security.auth.AuthenticationStatusImpl;
import com.sun.enterprise.security.auth.realm.Realm;

import javax.security.auth.login.LoginException;

/**
 * Provided for backward compatibility with SunOne 7.0
 * Newer implementations should extend
 * com.sun.appserv.security.AbstractPasswordLogin directly
 */
public abstract class PasswordLoginModule extends AppservPasswordLoginModule
{
    /**
     * authenticateUser calls authenticate which is implemented by the implementation
     * of this subclass
     * @throws LoginException
     */
    protected final void authenticateUser() throws LoginException{
        AuthenticationStatus as = authenticate();
        if(as.getStatus() == as.AUTH_SUCCESS)
            return;
        else{
            throw new LoginException();
        }
    }
    /** Called at the end of the authenticate method by the user
     * @return AuthenticationStatus indicating success/failure
     */
    public final AuthenticationStatus commitAuthentication(String username,
                                        String password,
                                        Realm theRealm,
                                        String[] groups)
    {
        commitUserAuthentication(groups);
        int status = AuthenticationStatus.AUTH_SUCCESS;
        String realm = theRealm.getName();
        String authMethod = theRealm.getAuthType();
        AuthenticationStatus as =
            new AuthenticationStatusImpl(username, authMethod, realm, status);
        return as;
    }
    abstract protected AuthenticationStatus authenticate() throws LoginException;
}
