/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/**
 * PROPRIETARY/CONFIDENTIAL.  Use of this product is subject to license terms.
 *
 * Copyright 2000-2001 by iPlanet/Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 */

package com.sun.appserv.server;

import javax.naming.InitialContext;

/**
 * LifecycleEventContext interface exposes the server-wide runtime environment 
 * that is created by ApplicationServer. This context has only accessors and 
 * is a subset of ServerContext used by the server runtime. 
 */
public interface LifecycleEventContext {
    /** 
     * Get the server command-line arguments
     */
    public String[] getCmdLineArgs();

    /**
     * Get server install root
     */
    public String getInstallRoot();
    
    /**
     * Get the server instance name
     */
    public String getInstanceName();
    
    /** 
     * Get the initial naming context.
     */
    public InitialContext getInitialContext();

    /**
     * Writes the specified message to a server log file.
     *
     * @param message 	a <code>String</code> specifying the 
     *			message to be written to the log file
     */
    public void log(String message);
    
    /**
     * Writes an explanatory message and a stack trace
     * for a given <code>Throwable</code> exception
     * to the server log file.
     *
     * @param message 		a <code>String</code> that 
     *				describes the error or exception
     *
     * @param throwable 	the <code>Throwable</code> error 
     *				or exception
     */
    
    public void log(String message, Throwable throwable);
}
