/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.ejb;

import java.lang.NoSuchMethodException;
import java.lang.reflect.Method;

/*
 * MessageBeanClient is an interface implemented by clients
 * of the MessageBeanContainer.  It contains lifecycle methods 
 * that allow the container to bootstrap the MessageBeanClient.
 * A MessageBeanClient is some part of the container that needs
 * to deliver messages to a message-driven bean.  
 *
 * @author Kenneth Saks
 */
public interface MessageBeanClient {

    /**
     * First method called by MessageBeanContainer during bootstrapping.
     * Allow the MessageBeanClient to initialize itself.  Message delivery
     * should not begin until start is called.  
     *
     * @param pm MessageBeanProtocolManager allows the MessageBeanClient to
     * access the services provided by the MessageBeanContainer.
     */
    void setup(MessageBeanProtocolManager pm) throws Exception;

    /**
     * MessageBeanContainer calls this when it is ready handle message delivery.
     */
    void start() throws Exception;

    /**
     * MessageBeanContainer calls this to shutdown MessageBeanClient.
     */
    void close();

}
