/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * IOUtilsCallerImpl.java
 *
 * Created on October 13, 2003, 11:40 AM
 */

package com.sun.ejb.base.io;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.IOException;
import com.sun.ejb.spi.io.NonSerializableObjectHandler;
import org.apache.catalina.session.IOUtilsCaller;
import org.apache.catalina.util.CustomObjectInputStream;

/**
 * This class is used by the web tier to obtain equivalent
 * object stream service as the ejb tier obtains from directly
 * using classes like IOUtils
 * @author  Administrator
 */
public class IOUtilsCallerImpl implements IOUtilsCaller{
    
    /** Creates a new instance of IOUtilsCallerImpl */
    public IOUtilsCallerImpl() {
    }
    
    public ObjectInputStream createObjectInputStream(
            final InputStream is,
            final boolean resolveObject,
            final ClassLoader loader)
        throws Exception {
        ObjectInputStream strm = null;
        try {
            strm = IOUtils.createObjectInputStream(is, resolveObject, loader);
        } catch (Exception ex) {}
        if (strm == null) {
            strm = new CustomObjectInputStream(is, loader);
        }
        return strm;
    }
    
    public ObjectOutputStream createObjectOutputStream(
        final OutputStream os,
        final boolean replaceObject) throws IOException {
        return IOUtils.createObjectOutputStream(os, replaceObject, 
            new NonSerializableObjectHandler() {
                public Object handleNonSerializableObject(Object obj) {
                    return obj;
                }
            }            
        );
    }     
    
    public ObjectOutputStream createObjectOutputStream(
        final OutputStream os,
        final boolean replaceObject,
        final NonSerializableObjectHandler handler) throws IOException {
        return IOUtils.createObjectOutputStream(os, replaceObject, handler);
    }    
    
}
