/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.base.sfsb.initialization;

import java.util.logging.Level;
import java.util.logging.Logger;

import com.sun.ejb.spi.sfsb.initialization.PersistenceStrategyBuilder;

import com.sun.logging.LogDomains;

/**
 *
 * @author  lwhite
 */
public class PersistenceStrategyBuilderFactory {
    
    /**
    * The default path to the EE persistence strategy builders
    *only used if getEEBuilderPath fails (which should only occur
    *in unit-test 
    */ 
    protected final String DEFAULT_EE_BUILDER_PATH = "com.sun.ejb.ee.sfsb.initialization";        
    
    /** Creates a new instance of PersistenceStrategyBuilderFactory */
    public PersistenceStrategyBuilderFactory() {
        if (_logger == null) {
            _logger = LogDomains.getLogger(LogDomains.EJB_LOGGER);
        }         
    }
    

    /**
     * creates the correct implementation of PersistenceStrategyBuilder
     * if an invalid combination is input; an error is logged
     * and MemoryStrategyBuilder is returned
     *
     * @param persistenceType
     * @param container
     * @param descriptor
     */    
    public PersistenceStrategyBuilder createPersistenceStrategyBuilder(
	    String persistenceType)
    {
        PersistenceStrategyBuilder builder = new FileStrategyBuilder();
        String className = createClassNameFrom(persistenceType);
        _logger.finest("PersistenceStrategyBuilderFactory>>createPersistenceStrategyBuilder: "
            + "CandidateBuilderClassName = " + className);      
	boolean requestedBuilderCreated = false;
        try {
            builder = 
                (PersistenceStrategyBuilder) (Class.forName(className)).newInstance();
	    requestedBuilderCreated = true;
        } catch (ClassNotFoundException clnfEx) {
	    _logger.log(Level.WARNING, "Couldn't find class: "
		    + className + " for persistenceType: "
		    + persistenceType);
            _logger.log(Level.FINE, "Exception while creating Builder", clnfEx);
        } catch (Exception ex) {
            _logger.log(Level.WARNING, "Exception while creating Builder", ex);
        }    
	if (! requestedBuilderCreated) {
            _logger.log(Level.WARNING, "Couldn't create builder for "
		    + "persistence type: " + persistenceType
		    +". Instead created FileStrategyBuilder....");
	}
        return builder;
    }     
    
    /**
     * returns an appropriately camel-cased String
     * that is a candidate class name for a builder
     * if persistenceType is "file" this returns
     * the correct class name and package name for these classes
     * i.e. com.sun.ejb.spi.?? 
     * FIXME:figure this out where the file builder
     * will reside
     * otherwise they are in com.sun.appserv.ee.web.initialization
     *
     * @param persistenceType
     */     
    private String createClassNameFrom(String persistenceType) {
        StringBuffer sb = new StringBuffer();
        //using package name will mean this will work
        //even if class is moved to another package
        String pkg = this.getClass().getPackage().getName();
        if( !(persistenceType.equalsIgnoreCase("file")) )  
        {
            //pkg is the package where EE builders MUST reside
            //this defaults to
            //"com.sun.enterprise.ee.web.initialization"
            // but is configurable via (not-well-publicized)
            //property in server.xml
            //at "/server/availability-service/persistence-store/property[@name='ee-builder-path']"
            pkg = this.getEEBuilderPath();
        }
        sb.append(pkg + ".");
        sb.append(camelCase(persistenceType));
        sb.append("StrategyBuilder");
        String classname = sb.toString();
        return classname;
    }    
    
    /**
     * this method strips out all non-alpha characters; camelCases the result
     *
     * @param inputString
     */     
    private String camelCase(String inputString) {
        String strippedString = stripNonAlphas(inputString);
        String firstLetter = (strippedString.substring(0, 1)).toUpperCase();
        String remainingPart = 
            (strippedString.substring(1, strippedString.length())).toLowerCase();
        return firstLetter + remainingPart;
    }

    /**
     * this method strips out all non-alpha characters
     *
     * @param inputString
     */     
    private String stripNonAlphas(String inputString) {
        StringBuffer sb = new StringBuffer(50);
        for(int i=0; i<inputString.length(); i++) {
            char nextChar = inputString.charAt(i);
            if(Character.isLetter(nextChar)) {
                sb.append(nextChar);
            }
        }
        return sb.toString();
    } 

    /**
     * return the path where the ee builders reside
     * although this method allows this to be configurable
     * via an property in server.xml we do not expose it
     * and it should not be re-configured
     *
     */    
    private String getEEBuilderPath() {
        return DEFAULT_EE_BUILDER_PATH;
    }    
    
    /**
     * The logger to use for logging ALL ejb container related messages.
     */
    private static Logger _logger = null;
    
}
