/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.ee.sfsb.store;

import java.util.logging.Logger;
import java.util.logging.Level;
import com.sun.logging.LogDomains;

import com.sun.ejb.spi.sfsb.store.SFSBTxStoreManager;
import com.sun.ejb.spi.sfsb.store.SFSBStoreManager;
import com.sun.ejb.spi.sfsb.store.SFSBBeanState;
import com.sun.ejb.spi.sfsb.store.SFSBStoreManagerException;

/**
 * A SFSBTxStoreManager that stores multiple SFSBBeanStates
 *  as a single transactional unit.
 *
 * @author Mahesh Kannan
 */
public class HaTxStoreManager
    implements SFSBTxStoreManager
{

    protected static Logger _logger =
	LogDomains.getLogger(LogDomains.EJB_LOGGER);

    public HaTxStoreManager() {
    }

    public void checkpointSave(SFSBBeanState[] beanStates)
        throws SFSBStoreManagerException
    {
	if ((beanStates == null) || (beanStates.length == 0)) {
	    _logger.log(Level.WARNING, "No BeanStates to checkpoint.");
	    return;
	}

	SFSBStoreManager manager = beanStates[0].getSFSBStoreManager();

	try {
	    ((SFSBTxStoreManager) manager).checkpointSave(beanStates);
	} catch (SFSBStoreManagerException smEx) {
	    _logger.log(Level.WARNING,
		"StoreManagerException during checkpointSave", smEx);
	} catch (Throwable th) {
	    _logger.log(Level.WARNING,
		"Exception during checkpointSave", th);
	}
    }

}
