/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.base.stats;

//import javax.management.j2ee.statistics.EntityBeanStats;
import javax.management.j2ee.statistics.CountStatistic;

import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;

import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistrationException;

import com.sun.ejb.spi.stats.EJBTimedObjectStatsProvider;

import java.util.logging.*;
import com.sun.enterprise.log.Log;
import com.sun.logging.*;

/**
 * A Class for providing stats related to Timers created from beans
 * of type STATELESS/ENTITY/MESSAGE_DRIVEN
 *
 */

public class EJBTimedObjectStatsImpl
    extends StatsImpl
    implements com.sun.enterprise.admin.monitor.stats.TimerServiceStats
{
    protected EJBTimedObjectStatsProvider	timerDelegate;

    private MutableCountStatisticImpl	createdCountStat;
    private MutableCountStatisticImpl	removedCountStat;
    private MutableCountStatisticImpl	deliveredCountStat;

    public EJBTimedObjectStatsImpl(EJBTimedObjectStatsProvider delegate) {
//	super(delegate, "javax.management.j2ee.statistics.TimerBeanStats");
	this.timerDelegate = delegate;

	initStats();
    }

    private void initStats() {
	createdCountStat = new MutableCountStatisticImpl(
		new CountStatisticImpl("NumTimersCreated"));
	removedCountStat = new MutableCountStatisticImpl(
		new CountStatisticImpl("NumTimersRemoved"));
	deliveredCountStat = new MutableCountStatisticImpl(
		new CountStatisticImpl("NumTimersDelivered"));
    }

    public CountStatistic getNumTimersCreated(){
	createdCountStat.setCount(timerDelegate.getTimersCreated());
	return (CountStatistic) createdCountStat.modifiableView();
    }

    public CountStatistic getNumTimersRemoved(){
	removedCountStat.setCount(timerDelegate.getTimersRemoved());
	return (CountStatistic) removedCountStat.modifiableView();
    }

    public CountStatistic getNumTimersDelivered(){
	deliveredCountStat.setCount(timerDelegate.getTimersDelivered());
	return (CountStatistic) deliveredCountStat.modifiableView();
    }

    public void monitoringLevelChanged( boolean monitoringOn ) {
        timerDelegate.monitoringLevelChanged( monitoringOn );
    }
}
