/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.base.stats;

import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.TimeStatistic;

import com.sun.ejb.spi.stats.MonitorableSFSBStoreManager;

import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.MutableTimeStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.TimeStatisticImpl;

/**
 * An instance of this class is used by the StatefulContainer to update monitoring 
 *  data. There is once instance of this class per StatefulEJBContainer
 *
 * @author Mahesh Kannan
 */

public class StatefulSessionStoreMonitor {

    private StatefulSessionStoreStatsImpl statsImpl;

    void setDelegate(StatefulSessionStoreStatsImpl delegate) {
	this.statsImpl = delegate;
    }

    final void appendStats(StringBuffer sbuf) {
	if (statsImpl != null) {
	    statsImpl.appendStats(sbuf);
	}
    }

    //The following methods are called from StatefulSessionContainer
    //
    public final boolean isMonitoringOn() {
	return (statsImpl != null);
    }

    public final void incrementActivationCount(boolean success) {
	StatefulSessionStoreStatsImpl delegate = statsImpl;
	if (delegate != null) {
	    delegate.incrementActivationCount(success);
	}
    }

    public final void incrementPassivationCount(boolean success) {
	StatefulSessionStoreStatsImpl delegate = statsImpl;
	if (delegate != null) {
	    delegate.incrementPassivationCount(success);
	}
    }

    public final void setActivationSize(long val) {
	StatefulSessionStoreStatsImpl delegate = statsImpl;
	if (delegate != null) {
	    delegate.setActivationSize(val);
	}
    }

    public final void setActivationTime(long val) {
	StatefulSessionStoreStatsImpl delegate = statsImpl;
	if (delegate != null) {
	    delegate.setActivationTime(val);
	}
    }

    public final void setPassivationSize(long val) {
	StatefulSessionStoreStatsImpl delegate = statsImpl;
	if (delegate != null) {
	    delegate.setPassivationSize(val);
	}
    }

    public final void setPassivationTime(long val) {
	StatefulSessionStoreStatsImpl delegate = statsImpl;
	if (delegate != null) {
	    delegate.setPassivationTime(val);
	}
    }

    public final void incrementExpiredSessionsRemoved(long val) {
	StatefulSessionStoreStatsImpl delegate = statsImpl;
	if (delegate != null) {
	    delegate.incrementExpiredSessionCountVal(val);
	}
    }

    public void incrementCheckpointCount(boolean success) {
	throw new RuntimeException("Checkpoint operation not allowed on non-HA store");
    }

    public void setCheckpointSize(long val) {
	throw new RuntimeException("Checkpoint operation not allowed on non-HA store");
    }

    public void setCheckpointTime(long val) {
	throw new RuntimeException("Checkpoint operation not allowed on non-HA store");
    }

    //The following methods are maintained for backward compatibility
    //Called from LruCache
    public int getNumExpiredSessionsRemoved() {
	StatefulSessionStoreStatsImpl delegate = statsImpl;
	return (delegate != null)
	    ? delegate.getNumExpiredSessionCount()
	    : 0;
    }

    public int getNumPassivationErrors() {
	StatefulSessionStoreStatsImpl delegate = statsImpl;
	return (delegate != null)
	    ? delegate.getNumPassivationErrorCount()
	    : 0;
    }

    public int getNumPassivations() {
	StatefulSessionStoreStatsImpl delegate = statsImpl;
	return (delegate != null)
	    ? delegate.getNumPassivationCount()
	    : 0;
    }

    public int getNumPassivationSuccess() {
	StatefulSessionStoreStatsImpl delegate = statsImpl;
	return (delegate != null)
	    ? delegate.getNumPassivationSuccessCount()
	    : 0;
    }

}
