/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.codegen;

import java.io.File;
import java.util.Collection;

import com.sun.enterprise.deployment.*;

/**
 * This interface must be implemented by all CMP code generators.
 */

public interface CMPGenerator {

    /**
     * This method is called once for each ejb module in the application
     * that contains CMP beans.
     * Only one #init() method can be called.
     * @deprecated
     * This method is not used by the deployment back end, and should be removed
     * as soon as the TestFramework is fixed.
     * @param ejbBundleDescriptor the EjbBundleDescriptor associated with this
     * ejb module.
     * @param cl the ClassLoader that loaded user defined classes.
     * @param bundlePathName full path to the directory where this bundle's
     * files are located.
     * @throws GeneratorException if there is a problem initializing bean 
     * processing.
     */
    void init(EjbBundleDescriptor ejbBundleDescriptor, ClassLoader cl,
        String bundlePathName) throws GeneratorException;

    /**
     * This method is called once for each ejb module in the application
     * that contains CMP beans.
     * Only one #init() method can be called.
     * @param ejbBundleDescriptor the EjbBundleDescriptor associated with this
     * ejb module.
     * @param ctx the EjbcContext associated with the deployment request.
     * @param bundlePathName full path to the directory where this bundle's
     * files are located.
     * @param generatedXmlsPathName full path to the directory where the 
     * generated files are located.
     * @throws GeneratorException if there is a problem initializing bean 
     * processing.
     */
    void init(EjbBundleDescriptor ejbBundleDescriptor, EjbcContext ctx,
        String bundlePathName, String generatedXmlsPathName) 
            throws GeneratorException;

    /**
     * This method is called once for each CMP bean of the corresponding ejb module.
     * @param descr the IASEjbCMPEntityDescriptor associated with this CMP bean.
     * @param srcout the location of the source files to be generated.
     * @param classout the location of the class files to be generated.
     * @throws GeneratorException if there is a problem processing the bean.
     */
    void generate(IASEjbCMPEntityDescriptor descr, File srcout, File classout)
        throws GeneratorException;

    /**
     * This method is called once for each ejb module in the application
     * that contains CMP beans. It is called at the end of the module processing.
     * @return a Collection of files to be compiled by the deployment process.
     * @throws GeneratorException if there is any problem.
     */
    Collection cleanup() throws GeneratorException;

    /**
     * This method may be called once for each CMP bean of the corresponding 
     * ejb module to perform the validation.
     * @param descr the IASEjbCMPEntityDescriptor associated with this CMP bean.
     * @return a Collection of Exceptions if there are any problems processing the bean.
     * Returns an empty Collection if validation succeeds.
     */
    Collection validate(IASEjbCMPEntityDescriptor descr);

} 
