/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/* 
 * IASEJBCTimes.java
 *
 * Created on June 23, 2002, 10:05 PM
 * 
 * @author  bnevins
 * @version $Revision: 1.3 $
 * <BR> <I>$Source: /cvs/glassfish/appserv-core/src/java/com/sun/ejb/codegen/IASEJBCTimes.java,v $
 *
 */

package com.sun.ejb.codegen;
 
/** 
 * This class gathers timing information for the sub-tasks of IASEJBC
 */

public class IASEJBCTimes 
{
	public IASEJBCTimes()
	{
	}

	///////////////////////////////////////////////////////////////////////////

	public long getTotalTime()
	{
		return totalTime;
	}

	///////////////////////////////////////////////////////////////////////////

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Total Time for EJBC: " + totalTime + " msec, ");
		sb.append(makeEntry("CMP Generation",	cmpGeneratorTime)); 
		sb.append(makeEntry("Java Compilation", javaCompileTime)); 
		sb.append(makeEntry("RMI Compilation",	RMICompileTime)); 
                sb.append(makeEntry("JAX-RPC Generation", jaxrpcGenerationTime));
		sb.append("\n");
		return sb.toString();
	}
	
	///////////////////////////////////////////////////////////////////////////
	
	private String makeEntry(String title, long time)
	{
		return title + ": " + time + " msec (" + percent(time) + "), ";
	}
	
	///////////////////////////////////////////////////////////////////////////
	
	private String percent(long time)
	{
		if(totalTime <= 0)
			return "0%";
		
		return "" + ((time * 100) / totalTime) + "%";
	}
	
	///////////////////////////////////////////////////////////////////////////
	
	long cmpGeneratorTime	= 0;
	long javaCompileTime	= 0;
	long RMICompileTime		= 0;
        long jaxrpcGenerationTime  = 0;
	long totalTime			= 0;
        
}
