/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.containers;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

import com.sun.ejb.containers.EJBLocalObjectImpl.SerializableLocalObject;
import com.sun.ejb.spi.io.IndirectlySerializable;
import com.sun.ejb.spi.io.SerializableObjectFactory;
import com.sun.enterprise.Switch;

/**
 * This class is used as a "proxy" or adapter between the business interface
 *  proxy and the EJBLocalObjectInvocationHandler. An instance of this class
 *  is created for each business interface of a bean. All java.lang.Object
 *  methods and mthods of IndirectlySerializable are handled by this 
 *  InvocationHandler itself while the business interface methods are delegated
 *  to the delegate (which is the EJBLocalObjectInvocaionHandler). 
 *   
 * @author Mahesh Kannan
 *
 */
public class EJBLocalObjectInvocationHandlerDelegate
    implements InvocationHandler {

    private Class intfClass;
    private long containerId;
    private EJBLocalObjectInvocationHandler delegate;
    
    EJBLocalObjectInvocationHandlerDelegate(Class intfClass, long containerId,
            EJBLocalObjectInvocationHandler delegate) {
        this.intfClass = intfClass;
        this.containerId = containerId;
        this.delegate = delegate;
    }
    
    public Object invoke(Object proxy, Method method, Object[] args) 
        throws Throwable {
        
        Class methodClass = method.getDeclaringClass();
        Object result = null;
        if( methodClass == java.lang.Object.class ) {
            result = InvocationHandlerUtil.invokeJavaObjectMethod
                (this, method, args);
        } else if( methodClass == IndirectlySerializable.class ) {
            result = this.getSerializableObjectFactory();
        }else {
            result = delegate.invoke(intfClass, method, args);
        }
        
        return result;
    }
    
    
    public int hashCode() {
        return (int) containerId;
    }
    
    public boolean equals(Object other) {
        boolean result = false;
        
        if ((other != null)
        && (other instanceof EJBLocalObjectInvocationHandlerDelegate)) {
            EJBLocalObjectInvocationHandlerDelegate otherDelegate
                    = (EJBLocalObjectInvocationHandlerDelegate) other;
            if ((containerId == otherDelegate.containerId)
            && (intfClass == otherDelegate.intfClass)) {
                EJBLocalObjectInvocationHandler otherHandler
                    = otherDelegate.delegate;
                result = (delegate.getKey() != null)
                    ? delegate.getKey().equals(otherHandler.getKey())
                    : (otherHandler.getKey() == null);
            }
        }
        
        return result;
    }

    public String toString() {
        return intfClass.getName() + "_" + System.identityHashCode(this);
    }
    
    public SerializableObjectFactory getSerializableObjectFactory() {
        // Note: for stateful SessionBeans, the EJBLocalObjectImpl contains
        // a pointer to the EJBContext. We should not serialize it here.
        
        return new SerializableLocalObjectDelegate(
            containerId, intfClass.getName(), delegate.getKey());
    }
    
    public static final class SerializableLocalObjectDelegate
        implements SerializableObjectFactory
    {
        private long containerId;
        private String intfClassName;
        private Object primaryKey;

        SerializableLocalObjectDelegate(long containerId, 
                String intfClassName, Object primaryKey) {
            this.containerId = containerId;
            this.intfClassName = intfClassName;
            this.primaryKey = primaryKey;
        }
        
        public Object createObject()
            throws IOException
        {
            BaseContainer container = (BaseContainer) Switch.getSwitch().
                getContainerFactory().getContainer(containerId);
            EJBLocalObjectImpl ejbLocalBusinessObjectImpl = 
                container.getEJBLocalBusinessObjectImpl(primaryKey);
            // Return the client EJBLocalObject.  
            return ejbLocalBusinessObjectImpl.getClientObject(intfClassName);
        }
    }
}
