/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.containers;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

import com.sun.ejb.containers.EJBLocalObjectImpl.SerializableLocalObject;
import com.sun.ejb.spi.io.IndirectlySerializable;
import com.sun.ejb.spi.io.SerializableObjectFactory;
import com.sun.enterprise.Switch;

/**
 * This class is used as a "proxy" or adapter between the remote business 
 * interface proxy and the EJBObjectInvocationHandler. An instance of this 
 * class is created for each remote business interface of a bean. All 
 * java.lang.Object methods are handled by this InvocationHandler itself 
 * while the business interface methods are delegated to the delegate 
 * (which is the EJBObjectInvocaionHandler). 
 *   
 * @author Kenneth Saks
 *
 */
public class EJBObjectInvocationHandlerDelegate
    implements InvocationHandler {

    private Class remoteBusinessIntfClass;
    private EJBObjectInvocationHandler delegate;
    
    EJBObjectInvocationHandlerDelegate(Class intfClass, 
                                       EJBObjectInvocationHandler delegate) {
        this.remoteBusinessIntfClass = intfClass;
        this.delegate = delegate;
    }
    
    public Object invoke(Object proxy, Method method, Object[] args) 
        throws Throwable {
        
        Class methodClass = method.getDeclaringClass();
        Object result = null;
        if( methodClass == java.lang.Object.class ) {
            result = InvocationHandlerUtil.invokeJavaObjectMethod
                (this, method, args);
        } else {
            result = delegate.invoke(remoteBusinessIntfClass, method, args);
        }
        
        return result;
    }
    
    

}
