/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.ejb.containers;

import java.lang.reflect.Method;
import com.sun.ejb.MessageBeanListener;
import com.sun.enterprise.resource.ResourceHandle;

/**
 *
 *
 * @author Kenneth Saks
 */
public class MessageBeanListenerImpl implements MessageBeanListener {
    
    private MessageBeanContainer container_;
    private ResourceHandle resourceHandle_;

    MessageBeanListenerImpl(MessageBeanContainer container, 
                            ResourceHandle handle) {
        container_ = container;

        // can be null
        resourceHandle_ = handle;
    }

    public void setResourceHandle(ResourceHandle handle) {
        resourceHandle_ = handle;
    }

    public ResourceHandle getResourceHandle() {
        return resourceHandle_;
    }

    public void beforeMessageDelivery(Method method, boolean txImported) {
        container_.onEnteringContainer();   //Notify Callflow Agent
        container_.beforeMessageDelivery(method, txImported, resourceHandle_);
    }
    
    public Object deliverMessage(Object[] params) throws Throwable {
        return container_.deliverMessage(params);
    }

    public void afterMessageDelivery() {
        try {
            container_.afterMessageDelivery(resourceHandle_);
        } finally {
            container_.onLeavingContainer();    //Notify Callflow Agent
        }
    }

}
