/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.ejb.containers;

import java.util.Date;

/**
 * Per-primary key information stored for read-only beans.
 *
 * @author Kenneth Saks
 */

final class ReadOnlyBeanInfo
{

    Object primaryKey;

    // Used to track staleness versus the bean-level refresh.
    int beanLevelSequenceNum;

    // Set to true when a programmatic refresh takes place.  
    boolean refreshNeeded;
    
    // Sequence number associated with a point in time when refresh occurred.
    // Each context for this pk also has a sequence number value.  If they
    // differ it means the context needs an ejbLoad.
    int pkLevelSequenceNum;

    // last time when refresh was programattically requested for this PK.
    long lastRefreshRequestedAt;
    
    // time at which refresh actually occurred.
    long lastRefreshedAt;
    
    Object	cachedEjbLocalObject;	    //Cached only for findByPK

    Object	cachedEjbObject;	    //Cached only for findByPK

    public String toString() {
        
        StringBuffer buffer = new StringBuffer();
        buffer.append("Read Only Bean Info for " + primaryKey + "\n");
        buffer.append("Refresh needed = " + refreshNeeded + "\n");
        buffer.append("Bean level sequence num = " + beanLevelSequenceNum 
                      + "\n");
        buffer.append("PK level sequence num = " + pkLevelSequenceNum + "\n");
        if( lastRefreshRequestedAt > 0 ) {
            buffer.append("Last refresh requested at " + 
                          new Date(lastRefreshRequestedAt) 
                          + "\n");
        } else {
            buffer.append("Refresh has never been requested\n");
        }
        if( lastRefreshedAt > 0 ) {
            buffer.append("Last refreshed at " + 
                          new Date(lastRefreshedAt) + "\n");
        } else {
            buffer.append("Never refreshed\n");
        }
        
        return buffer.toString();
    }
    
}
