/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.containers;

import java.util.Set;

import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;

import java.util.logging.Logger;
import java.util.logging.Level;

import com.sun.logging.LogDomains;

/**
 *
 */
public abstract class TimerMigrationBean implements EntityBean {

    private static Logger logger = LogDomains.getLogger(LogDomains.EJB_LOGGER);

    //
    // CMP fields
    //

    // primary key
    public abstract String getTimerId();      
    public abstract void setTimerId(String timerId);

    public abstract String getOwnerId();
    public abstract void setOwnerId(String ownerId);

    //
    // ejbSelect methods for timer ids
    //
    
    public abstract Set ejbSelectAllTimersByOwner(String ownerId) 
        throws FinderException;
   

    // This view of the timer info does not support creation.

    public void setEntityContext(EntityContext context) {}
    
    public void unsetEntityContext() {}
    
    public void ejbRemove() {}
    
    public void ejbLoad() {}

    public void ejbStore() {}
    
    public void ejbPassivate() {}
    
    public void ejbActivate() {}

    public Set ejbHomeSelectAllTimersOwnedBy(String ownerId)
        throws FinderException {
        return ejbSelectAllTimersByOwner(ownerId);
    }

}
