/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.comm;

//jdk imports
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URLConnection;
import java.net.HttpURLConnection;
import java.net.URL;

//admin imports
import com.sun.enterprise.admin.common.*;
import com.sun.enterprise.admin.common.constant.AdminConstants;
import com.sun.enterprise.admin.util.*;

/**
    Class communicating with Servlet over HTTP. Internally it uses java.net.URLConnection,
    for we may need to use it for both HTTP and HTTPS. In case of
    java.net.HttpURLConnection, only HTTP can be used.

    @author Kedar Mhaswade
    @version 1.0
*/
 class ServletConnection implements IConnection
{
    static final String         UNKNOWN_HOST            = "Unknown host : ";
    static final String         INVALID_HOST_PORT       = "Unable to connect to admin-server.  Please check if the server is up and running and that the host and port provided are correct.";
    static final String         UNAUTHORIZED_ACCESS     = 
        "Invalid user or password";

    private URLConnection        mConnection           = null;
    private ObjectOutputStream   mObjectOutStream      = null;
    private ObjectInputStream    mObjectInStream       = null;


   ServletConnection(HttpConnectorAddress a) throws IOException{
	 try{
	   mConnection = a.openConnection("/"+AdminConstants.kAdminServletURI);
	 }
	 catch (IOException ioe){
	   handleException(ioe);
	 }
   }


    /**
        Read an incoming Object.
     */
    public  Object receive(  ) throws IOException, ClassNotFoundException
    {
        Object value = null;
        try
        {
            mObjectInStream = new ObjectInputStream(
                new BufferedInputStream(mConnection.getInputStream()));
            value = mObjectInStream.readObject();
        }
        catch (IOException ioe)
        {
            handleException(ioe);
        }
        return value;
    }

    /**
        Write an object to the connection
     */
    public  void	send( Serializable object ) throws IOException
    {
        try
        {
            mObjectOutStream = new ObjectOutputStream(
                                    new BufferedOutputStream(
                                        mConnection.getOutputStream()));
            mObjectOutStream.writeObject(object);
            mObjectOutStream.flush();
            mObjectOutStream.close();
        }
        catch (IOException ioe)
        {
            handleException(ioe);
        }
    }

    public void	close()
    {
        try
        {
            mObjectInStream.close();
            mObjectOutStream.close();
        }
        catch(Exception e)
        {
            Debug.printStackTrace(e);
        }
    }


    private void handleException(IOException e) throws IOException
    {
        IOException exception = null;
        if (e instanceof java.net.UnknownHostException)
        {
            exception = new java.net.UnknownHostException(UNKNOWN_HOST + 
                                                          e.getMessage());
        }
        else if (e instanceof java.net.ConnectException)
        {
            exception = new java.net.ConnectException(INVALID_HOST_PORT);
        }
        else
        {
            int responseCode = 
                ((HttpURLConnection)mConnection).getResponseCode();
            if (responseCode == HttpURLConnection.HTTP_UNAUTHORIZED)
            {
                exception = new IOException(UNAUTHORIZED_ACCESS);
            }
            else
            {
                exception = e;
            }
        }
        throw exception;
    }
}
