/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.common;

import java.util.Random;

import java.net.ServerSocket;
import java.io.IOException;
import com.sun.enterprise.admin.common.exception.PortInUseException;
import com.sun.enterprise.admin.util.Debug;

// i18n import 
import com.sun.enterprise.admin.util.SOMLocalStringsManager;

/**
A utility class to check the port availability etc.
*/


public class NetUtil
{
	public static final int			kMaxPortNo		= 65535;
	
    /**
		Static method to check whether the port provided is available to connect to.
		Uses ServerSocket for this check.
		@throws PortInUseException
    */
	
    public static void checkPortAvailability(int port) throws PortInUseException
    {
        ServerSocket trialSocket = null;
        try
        {
            trialSocket = new ServerSocket(port);
        }
        catch(IOException ioe)
        {
			String msg = localizedStrMgr.getString( "admin.common.port_in_use", new String( port + "" ) );
            throw new PortInUseException( msg );
        }
        finally
        {
            try
            {
				if (trialSocket != null)
				{
					trialSocket.close();
				}
            }
            catch(Exception e)
            {
                Debug.printStackTrace(e);
            }
        }
    }
	
	/**
		Returns whether the given port number is available at the time of
		call.
	 
		@param portNo integer specifying the port.
	*/
	
	public static boolean isPortAvalable(int portNo)
	{
		boolean available = true;
		
		try
		{
			checkPortAvailability(portNo);
		}
		catch(Exception e)
		{
			available = false;
		}
		return ( available );
	}

    private static Random random = new Random();

	// i18n SOMLocalStringsManager
	private static SOMLocalStringsManager localizedStrMgr =
		SOMLocalStringsManager.getManager( NetUtil.class );

    public static int getFreePort()
    {
        synchronized(NetUtil.class)
        {
            /* scared of using infinite while loop */
            for (int i = 0; i < 1024; i++) 
            {
                int nextInt = random.nextInt(kMaxPortNo);
                if (nextInt <= 1024)
                {
                    continue;
                }
                else if (isPortAvalable(nextInt))
                {
                    return nextInt;
                }
            }
        }
        return 0;
    }
}
