/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.common.constant;

/**
    Constants needed by the JMS administration handler.
 */
public final class JMSAdminConstants
{
    // JMS Object types
    public static final String JMS_OBJ_TYPE_TOPIC		= "topic";
    public static final String JMS_OBJ_TYPE_QUEUE		= "queue";
    public static final String JMS_OBJ_TYPE_QUEUE_CONN_FACTORY	= "qconfactory";
    public static final String JMS_OBJ_TYPE_TOPIC_CONN_FACTORY	= "tconfactory";

    // JMS destination types
    public static final String JMS_DEST_TYPE_TOPIC		= "topic";
    public static final String JMS_DEST_TYPE_QUEUE		= "queue";

    // JMS Ping status values
    public static final String JMS_HOST_RUNNING			= "RUNNING";

    /**
        Convenience method for checking if the JMS object type specified is valid.

	@param objType The JMS object type.
	@return true if the object type specified was valid. False if it
	is not valid.
    */
    public static boolean isValidJMSObjType(String objType)
    {
	if ( (objType.equals(JMS_OBJ_TYPE_TOPIC)) ||
	     (objType.equals(JMS_OBJ_TYPE_QUEUE)) ||
	     (objType.equals(JMS_OBJ_TYPE_QUEUE_CONN_FACTORY)) ||
	     (objType.equals(JMS_OBJ_TYPE_TOPIC_CONN_FACTORY)) )
	{
	    return (true);
	}

	return (false);
    }

    /**
        Convenience method for checking if the JMS destination type specified 
	is valid.

	@param destType The destination type.
	@return true if the destination type specified was valid. False if it
	is not valid.
    */
    public static boolean isValidJMSDestType(String destType)
    {
	if ( (destType.equals(JMS_DEST_TYPE_TOPIC)) ||
	     (destType.equals(JMS_DEST_TYPE_QUEUE)) )
	{
	    return (true);
	}

	return (false);
    }
}
