/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.event;

import java.util.List;
import java.util.Iterator;
import java.lang.reflect.Method;
import java.lang.reflect.InvocationTargetException;
import java.lang.NoSuchMethodException;


/**
 * This class calls appropriates listener method for the event with a specific
 * action code
 *
 * @author Satish Viswanatham
 */
 public class BaseAdminEventHandler {

    /**
     * Constructor
     */
     public BaseAdminEventHandler(AdminEvent event) {
        _event = event;
     }

     /**
      * This method processes the event.
      */
      public int processEvent() {
        List list = AdminEventMulticaster.getInstance().getListeners(
                            _event.getType());
                if (list != null && !list.isEmpty()) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                AdminEventListener listener =
                        (AdminEventListener)iter.next();
                invokeAdminEventListener(listener, _event);
            }
        }
        return ((list != null) ? list.size() : 0);
      }

    private void invokeNotification(AdminEventListener ae, String methodName,
                          AdminEvent e) throws Exception
    {
        invokeNotification(ae, methodName, e, ((Object)e).getClass());
    }
    
    private void invokeNotification(AdminEventListener ae, String methodName,
                          AdminEvent e, Class eventParamClass) throws Exception
    {
        Method meth = null;
        meth = ae.getClass().getMethod( methodName, new Class[]{eventParamClass});
        try {
            meth.invoke(ae, new Object[]{e});
        } catch (Exception ex) {
            Throwable t = ex.getCause();
            if (t != null) {
                throw (Exception)t;
            }
            else {
                throw ex;
            }
        } 
    }

    private void invokeAdminEventListener(
            AdminEventListener listener,
            AdminEvent e) {
        
        AdminEventMulticaster aem = AdminEventMulticaster.getInstance();
        AdminEventResult result = AdminEventResult.getAdminEventResult(e);

        try {
           invokeNotification(listener, GENERIC_PROCESS_EVENT_METHOD, e);
           return;
        }catch (Throwable t) {
            if( !(t instanceof NoSuchMethodException))
                aem.handleListenerError(e, t, result);
        }
        
        try {
           invokeNotification(listener, GENERIC_PROCESS_EVENT_METHOD, e, AdminEvent.class);
           return;
        }catch (Throwable t) {
            if( !(t instanceof NoSuchMethodException))
                aem.handleListenerError(e, t, result);
        }
    
        try {
            ElementChangeEvent event = (ElementChangeEvent)e;
            int code = event.getActionType();
            if ( code == ElementChangeEvent.ACTION_ELEMENT_CREATE ) {
                invokeNotification(listener,ACTION_CREATE_METHOD, e);
            } else if ( code == ElementChangeEvent.ACTION_ELEMENT_UPDATE) {
                invokeNotification(listener,ACTION_UPDATE_METHOD, e);
            } else if (code == ElementChangeEvent.ACTION_ELEMENT_DELETE) {
                invokeNotification(listener,ACTION_DELETE_METHOD, e);
            } else {
                throw new RuntimeException("not valid error code");
            }
        } catch (Throwable t) {
            aem.handleListenerError(e, t, result);
        }
    }

    private AdminEvent _event;

    // Method to be called in the listener for action of type 
    //  ACTION_UPDATE_METHOD
    private static String ACTION_UPDATE_METHOD = "handleUpdate";

    // Method to be called in the listener for action of type 
    //  ACTION_DELTE_METHOD
    private static String ACTION_DELETE_METHOD = "handleDelete";

    // Method to be called in the listener for action of type 
    //  ACTION_CREATE_METHOD
    private static String ACTION_CREATE_METHOD = "handleCreate";

    // Generic method to be called in the listener
    private static String GENERIC_PROCESS_EVENT_METHOD = "processEvent";
 }
