/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.event;

public interface EjbTimerEventListener extends AdminEventListener {

   /**
    * Migrates all ejb timers that belongs to the "from" server instance 
    * to the targeted server instance. 
    *
    * @param  event timer event 
    * @param  from  name of the server instance from where
    *               ejb timers need to be migrated 
    * @returns number of timers that were migrated
    * @throws  AdminEventListenerException
    *   when the listener is unable to process the event
    */ 
   public int migrateTimer(EjbTimerEvent event, String from) 
	   throws AdminEventListenerException;
  
   /**
    * Returns all active timers associated with the given server ids.
    *
    * @param  event timer event 
    * @param  servers  name of server instances 
    *
    * @returns  description of all active timers associated with the given 
    *           server ids 
    *
    * @throws  AdminEventListenerException  
    *   when the listener is unable to process the event
    */
   public String[] listTimers(EjbTimerEvent event, String[] servers) 
	   throws AdminEventListenerException;

}
