/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/**
 * PROPRIETARY/CONFIDENTIAL.  Use of this product is subject to license terms.
 *
 * Copyright 2001-2002 by iPlanet/Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 */
package com.sun.enterprise.admin.event;

import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.ServerXPathHelper;

/**
 * Listener for config changes handled by web core. Web core handles changes
 * to http-service and web-container elements of server.xml without restart.
 * This class allows Java notification framework to determine that all such
 * changes are handled dynamically.
 */
public class WebConfigChangeEventListener implements ConfigChangeEventListener {

    /**
     * Useful constant to denote one or more match in a regular expression
     */
    private static final String ONE_OR_MORE = ServerXPathHelper.REGEX_ONE_PLUS;

    /**
     * Regular expression for server.xml xpaths dynamically handled by web core
     * -- <code>/{1,}server/{1,}(http-service|web-container).*</code>
     */
    public static final String CATEGORY_REGEX =
            ServerXPathHelper.REGEX_XPATH_CONFIG
            + ServerXPathHelper.XPATH_SEPARATOR + ONE_OR_MORE
            + "(" + ServerTags.HTTP_SERVICE + "|" + ServerTags.WEB_CONTAINER
            + ").*";

    /**
     * Config change category handled by this listener. 
     */
    private ConfigChangeCategory category = new ConfigChangeCategory("webcore",
            CATEGORY_REGEX);

    /**
     * Handle config changes. If init.conf or obj.conf has changed for the
     * instance then set the status of "Restart Required".
     */
    public void configChanged(ConfigChangeEvent configChangeEvent)
            throws AdminEventListenerException {
        if (configChangeEvent.isInitOrObjConfChanged()) {
            AdminEventMulticaster.notifyFailure(configChangeEvent,
                    AdminEventResult.RESTART_NEEDED);
        }
    }

    /**
     * Get category handled by this listener. Used while registering the
     * event listener.
     */
    public ConfigChangeCategory getConfigChangeCategory() {
        return category;
    }
}
