/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.event.http;

import com.sun.enterprise.admin.event.ElementChangeEvent;

//i18n import
import com.sun.enterprise.util.i18n.StringManager;

/**
 * <pre>
 *      The following attributes of http-access-log are handled.
 *          log-directory
 * </pre>
 *
 * @author: Satish Viswanatham
 */
public class HSHttpAccessLogEvent extends ElementChangeEvent {

    /**
     * Event type
     */
    public static final String eventType = HSHttpAccessLogEvent.class.getName();

    /**
     * Create a new HSHttpAccessLogEvent.
     *
     * @param instance name of the instance to which the event applies
     * @param action type of action - one of HSHttpAccessLogEvent.ACTION_UPDATE
     *
     * @throws IllegalArgumentException if specified action is not valid
     */
    public HSHttpAccessLogEvent(String instance, int action) {
        super(instance, HSHttpAccessLogEvent.eventType, action, null);
    }

}
