/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.monitor;


/**
 * This SPI mechanism allows loaders to call web services Management module to
 * initialize web service endpoints for monitoring and management. JSR 77 and
 * Monitoring MBeans are created at this time.
 * <br>
 */
public class WSMonitorLifeCycleFactory {

    /**
     * WSMonitorLifeCycleFactory is private. Only one sigleton object is available
     * is available through getInstance method.
     */
    private WSMonitorLifeCycleFactory () {
    }

    /**
     * Returns the WSMonitorLifeCycleFactory singleton.
     *
     * @return the WSMonitorLifeCycleFactory instance
     */
    public static WSMonitorLifeCycleFactory  getInstance() {
        return lcf;
    }

    /**
     * Returns the WSLifeCycleProvider instance. If 
     * -Dwsmgmt.lifecycle.provider.classname is defined,that class is loaded and
     * returned as the WSLifeCycle provider. If there is an error finding or 
     * loading the class, the default provider class is returned.
     *
     * @return WSMonitorLifeCycleProvider implementation
     * @throws IllegalAccessException - if the class or its nullary constructor 
     *                                  is not accessible. 
     *         InstantiationException - if this Class represents an abstract 
     *                                  class,an interface, an array class, a 
     *                                  primitive type, or void; or if the class     *                                  has no nullary constructor; or if the 
     *                                  instantiation fails for some other 
     *                                  reason. 
     *         ClassCastException     - if the provider implementation specified
     *                                  by -D does not implement the com.sun.
     *                                  enterprise.admin.wsmgmt.repository.spi.
     *                                  RepositoryProvider interface.
     *         ClassNotFoundException - if the provider implementation specified     *                                  by -D does could not be found by the 
     *                                  class loader.
     */
    public WSMonitorLifeCycleProvider getWSMonitorLifeCycleProvider() 
      throws InstantiationException, IllegalAccessException, ClassCastException,
        ClassNotFoundException {
       String implName = System.getProperty(WSMGMT_PROVIDER_NAME);
       if ( implName == null ) {
            Class repClass = Class.forName(WSMGMT_DEFAULT_PROVIDER);
            Object o = repClass.newInstance();
            return (WSMonitorLifeCycleProvider)o;
       } else {
            Class repClass = Class.forName(implName);
            Object o = repClass.newInstance();
            return (WSMonitorLifeCycleProvider)o;
       }
    }

    /** Environment property name to customize Repository Provider */
    public static final String WSMGMT_PROVIDER_NAME = 
        "wsmgmt.lifecycle.provider.classname";

    public static final String WSMGMT_DEFAULT_PROVIDER = 
        "com.sun.enterprise.admin.wsmgmt.lifecycle.AppServWSMonitorLifeCycleProvider";

    // PRIVATE VARS
    static WSMonitorLifeCycleFactory lcf = new WSMonitorLifeCycleFactory();
}
