/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.selfmanagement.event;
import javax.management.ObjectName;
import javax.management.NotificationFilter;
import com.sun.enterprise.util.i18n.StringManager;


public class NotificationEvent implements Event {
    private static StringManager sm = StringManager.getManager(NotificationEvent.class);
    NotificationEvent(ObjectName objName, String description) {
        this.objName = objName;
        if (description != null)
            this.description = description;
        else
            this.description = defaultDescription;
    }
    public ObjectName getObjectName() {
        return objName;
    }
    public String getType() {
        return "notification";
    }
    public NotificationFilter getNotificationFilter() {
        return null;
    }
    
    public String getDescription() {
        return description;
    }
    public void destroy() {
        // Nothing to do
    }
    private ObjectName objName = null;
    private String description = null;
    private static String defaultDescription = sm.getString("selfmgmt_event.notification_event_description");
}
