/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/**
 * PROPRIETARY/CONFIDENTIAL.  Use of this product is subject to license terms.
 *
 * Copyright 2001-2002 by iPlanet/Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 */
package com.sun.enterprise.admin.server.core.channel;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.server.RMIClientSocketFactory;

/**
 * Local RMI Client Socket Factory. This class creates client sockets
 * that connect to local loopback address. This class needs to be Serializable
 * because RMI stubs contain a reference to client socket factory.
 */
public class LocalRMIClientSocketFactory implements RMIClientSocketFactory,
        Serializable {

    private InetAddress localLoopbackAddress;

    /**
     * Create a new local RMI Client Socket Factory. This method uses <code>null
     * </code> argument to <code>InetAddress.getByName()</code> to determine
     * local loopback address.
     * @throws UnknownHostException as thrown from the method <code>
     * InetAddress.getByName()</code>.
     */
    public LocalRMIClientSocketFactory() throws UnknownHostException {
        localLoopbackAddress = InetAddress.getByName(null);
    }

    /**
     * Create a new local RMI Client Socket Factory on specified local IP
     * address. Use this constructor when you know the local loopback IP
     * address and do not want to handle UnknownHostException thrown by default
     * constructor.
     * @param localAddr local loopback address.
     */
    public LocalRMIClientSocketFactory(InetAddress localAddr) {
        localLoopbackAddress = localAddr;
    }

    /**
     * Create a new socket that connects to local loopback address and
     * specified port. This method ignores host parameter. The method comes
     * from the interface <code>java.rmi.server.RMIClientSocketFactory</code>
     * @param host host to connect to, this is ignored and local loopback
     *      address is used.
     * @param port port to connect to
     * @throws IOException if an IO error occurs while creating the socket
     * @return a Socket connected to local loopback address on specified port
     */
    public Socket createSocket(String host, int port) throws IOException {
        return new Socket(localLoopbackAddress, port);
    }

}
