/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.server.core.mbean.config;

//JMX imports
import javax.management.*;

//Config imports
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ServerTags;


//Admin imports
import com.sun.enterprise.admin.server.core.mbean.meta.MBeanEasyConfig;
import com.sun.enterprise.admin.common.exception.MBeanConfigException;
import com.sun.enterprise.admin.common.constant.ConfigAttributeName;
import com.sun.enterprise.admin.common.ObjectNames;

public class ManagedTransactionService extends ConfigMBeanBase implements ConfigAttributeName.TransactionService
{
 private static final String[][] MAPLIST  =  {
  { kAutomaticTransactionRecovery,    ATTRIBUTE + ServerTags.AUTOMATIC_RECOVERY},
  { kTransactionRecoveryTimeout,      ATTRIBUTE + ServerTags.TIMEOUT_IN_SECONDS},
  { kTransactionLogDir,               ATTRIBUTE + ServerTags.TX_LOG_DIR},
  { kHeuristicDecision,               ATTRIBUTE + ServerTags.HEURISTIC_DECISION},
  { kKeypointInterval,                ATTRIBUTE + ServerTags.KEYPOINT_INTERVAL},
//ms1  { kLogLevel,                        ATTRIBUTE + ServerTags.LOG_LEVEL},
  // { kMonitoringEnabled,               ATTRIBUTE + ServerTags.MONITORING_ENABLED}
};

 private static final String[]   ATTRIBUTES  = {
    kAutomaticTransactionRecovery + ",     boolean, RW",
    kTransactionRecoveryTimeout   + ",     int, RW",
    kTransactionLogDir            + ",     String, RW",
    kHeuristicDecision            + ",     String, RW",
    kKeypointInterval             + ",     int, RW",
//ms1    kLogLevel                     + ",     String, RW",
   // kMonitoringEnabled            + ",     boolean, RW",
 };

 private static final String[]   OPERATIONS  = null;

    /**
        Default constructor sets MBean description tables
    */
    public ManagedTransactionService() throws MBeanConfigException
    {
        this.setDescriptions(MAPLIST, ATTRIBUTES, OPERATIONS);
    }

    public ManagedTransactionService(String instanceName) throws MBeanConfigException
    {
        this(); //set description tables
        initialize(ObjectNames.kJtsComponent, new String[]{instanceName});
    }

}
