/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * EasyConfigTestMBean.java
 *
 * Created on December 14, 2001, 8:10 PM
 */

package com.sun.enterprise.admin.server.core.mbean.test;

//Admin imports
import com.sun.enterprise.admin.server.core.mbean.config.AdminBase;
import com.sun.enterprise.admin.server.core.mbean.meta.*;

import javax.management.*;
import com.sun.enterprise.admin.util.*;

/**
 *
 * @author  alexkrav
 * @version 
 */
public class EasyConfigTestMBean extends AdminBase
{
	public String[] attrs = {"color, java.lang.String,   RW, Color of bean",
	                         "size,  java.lang.String[], RW, Size of bean(array)",
	                         "testInt,  int,             R,  Test int value",
	                         "testInt3DSArray,  int[][][],  R,  Test int3DArray value",
	                         "testInfoArr, javax.management.MBeanAttributeInfo[],  R,  Test info[] value"}  ;
	public String[] opers = {"setColor(java.lang.String clr Description for string color), ACTION, Test method(setColor)",
	                         "emptyParamMethod(), INFO, Test empty param-list methodemptyParamMethod",
	                         "testComplexMethod("+
	                                  "int intValue Description for intValue ,"+
	                                  "int[] intArrayValue Description for intArrayValue,"+
	                                  "java.lang.String[][][] str3DArray Description for str3DArray), ACTION_INFO, Test method(testComplexMethod)"
	                         };

	                                  
	public String Smell  = null;
	public String Taste = null;

	/** 
		Creates new EasyConfigTestMBean
	*/
    
	public EasyConfigTestMBean ()
	{
  }
	
	public EasyConfigTestMBean(String msg)
	{
	}
	
	public EasyConfigTestMBean(String[] msgs, int testCode)
	{
	}

	public MBeanInfo getMBeanInfo()
	{
	   try {
	     return (new MBeanEasyConfig(getClass(), attrs, opers, "TEST BEAN")).getMBeanInfo();
	   } catch(Exception e)
	   {
	     System.out.println("++++++++++++++++++++E X C E P T I O N+++++++++++++++++++++++++ getMBeanInfo():Exception:"+e);
	     e.printStackTrace();
	     return null;
	   }
	   
	}
	public String getColor()
	{
		return "test";
	}
	public void setColor(String c)
	{
	}
	public String getSmell()
	{
		return "test";
	}

	public boolean testComplexMethod(int intValue, int[] intValue2, String[][][] str)
	{
		return false;
	}

	public void emptyParamMethod()
	{
	}
    /** Every resource MBean should override this method to execute specific
     * operations on the MBean. This method is enhanced in 8.0. It was a no-op
     * in 7.0. In 8.0, it is modified to invoke the actual method through
     * reflection.
     * @since 8.0
     * @see javax.management.MBeanServer#invoke
     * @see #getImplementingClass
     */
    protected Class getImplementingClass() {
        return ( this.getClass() );
    }
    
    /** Reflection requires the implementing object. 
     * @since 8.0
    */
    protected Object getImplementingMBean() {
        return ( this );
    }

}
