/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.server.core.mbean.test;

import javax.management.*;
//import com.sun.enterprise.admin.server.core.mbean.meta.*;
import com.sun.enterprise.admin.util.*;

public class MBeanEasyConfigTester
{

	/** 
		 Creates new MBeanInfoTester
	*/
    
	public MBeanEasyConfigTester()
	{
  }

    /**
		@param args the command line arguments
    */
    
	public static void main (String args[])
	{
		new MBeanEasyConfigTester().test();
  }

	public void test()
	{
		try
		{
			printInfo((new EasyConfigTestMBean()).getMBeanInfo());
		}
		catch(Exception e)
		{
			
			e.printStackTrace();
		}
	}
	private void printInfo(MBeanInfo info)
	{
	   print("************** MBeanInfo ******************");
	   print("ClassName="+info.getClassName());
	   print("Description="+info.getDescription());
	   printInfo(info.getAttributes());
	   printInfo(info.getConstructors());
	   printInfo(info.getNotifications());
	   printInfo(info.getOperations());
	}

	//*****************************************************************************************
	private void printInfo(MBeanAttributeInfo info)
	{
	  print("   ************** MBeanAttributeInfo ******************");
	  print("   name="+info.getName());
	  print("   description="+info.getDescription());
	  print("   type="+info.getType());
	  print("   isReadable="+info.isReadable());
	  print("   isWritable="+info.isWritable());
	  print("   isIs="+info.isIs());
	}

	//*****************************************************************************************
	private void printInfo(MBeanConstructorInfo info)
	{
	  print("   ************** MBeanConstructorInfo ******************");
	  print("   name="+info.getName());
	  print("   description="+info.getDescription());
	  printInfo(info.getSignature());
	}

	//*****************************************************************************************
	private void printInfo(MBeanNotificationInfo info)
	{
	  print("   ************** MBeanNotificationInfo ******************");
	  print("   name="+info.getName());
	  print("   description="+info.getDescription());
	  printInfo(info.getNotifTypes());
	}
	//*****************************************************************************************
	private void printInfo(MBeanOperationInfo info)
	{
	  print("   ************** MBeanOperationInfo ******************");
	  print("   name="+info.getName());
	  print("   description="+info.getDescription());
	  String str = "???";
	  switch(info.getImpact())
	    {
	      case MBeanOperationInfo.UNKNOWN:
	         str = "UNKNOWN";
	         break;
	      case MBeanOperationInfo.ACTION:
	         str = "ACTION";
	         break;
	      case MBeanOperationInfo.INFO:
	         str = "INFO";
	         break;
	      case MBeanOperationInfo.ACTION_INFO:
	         str = "ACTION_INFO";
	         break;
	    }
	  print("   returnType="+info.getReturnType());
    print("   impact="+str);
	  printInfo(info.getSignature());
	}
	//*****************************************************************************************
	private void printInfo(MBeanParameterInfo info)
	{
	  print("      ************** MBeanParameterInfo ******************");
	  print("      name="+info.getName());
	  print("      description="+info.getDescription());
	  print("      type="+info.getType());
	}


	//*****************************************************************************************
	private void printInfo(Object[] infos)
	{
	  for(int i=0; i<infos.length; i++)
	    if(infos[i] instanceof MBeanAttributeInfo)
        printInfo((MBeanAttributeInfo)infos[i]);   
	    else 
	      if(infos[i] instanceof MBeanConstructorInfo)
	        printInfo((MBeanConstructorInfo)infos[i]);   
	      else 
	        if(infos[i] instanceof MBeanNotificationInfo)
	          printInfo((MBeanNotificationInfo)infos[i]);   
	        else 
	          if(infos[i] instanceof MBeanOperationInfo)
	            printInfo((MBeanOperationInfo)infos[i]);   
	          else 
              if(infos[i] instanceof MBeanParameterInfo)
                printInfo((MBeanParameterInfo)infos[i]);
              else
                print("      "+infos[i]); //notif types?
	}
  
	//*****************************************************************************************
  private void print(String str)
  {
    System.out.println(str);
  }
}