/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * $Id: Target.java,v 1.3 2005/12/25 04:14:39 tcfujii Exp $
 */

package com.sun.enterprise.admin.target;

//jdk imports
import java.io.Serializable;

//config imports
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;

import com.sun.enterprise.util.i18n.StringManager;

import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.NodeAgent;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.ResourceRef;

public abstract class Target implements Serializable
{
    /**
     * i18n strings manager object
     */
    private static final StringManager strMgr = 
        StringManager.getManager(Target.class);

    private final String        name;
    private final transient ConfigContext cc;

    Target(String name, ConfigContext cc)
    {
        checkArg(name, strMgr.getString("target.name"));
        checkArg(cc, strMgr.getString("target.config_context"));
        this.name   = name;
        this.cc     = cc;
    }

    public String getName()
    {
        return name;
    }

    public abstract TargetType getType();
    public abstract String getConfigRef() throws ConfigException;
    public abstract ConfigTarget getConfigTarget() throws Exception;
    public abstract String getTargetObjectName(String[] tokens);
    
    public abstract Server[] getServers() throws ConfigException;
    public abstract Cluster[] getClusters() throws ConfigException;
    public abstract Config[] getConfigs() throws ConfigException;
    public abstract NodeAgent[] getNodeAgents() throws ConfigException;
    public abstract ApplicationRef[] getApplicationRefs() throws ConfigException;
    public abstract ResourceRef[] getResourceRefs() throws ConfigException;

    protected ConfigContext getConfigContext()
    {
        return cc;
    }

    protected void checkArg(Object o, Object name)
    {
        if (null == o)
        {
            throw new IllegalArgumentException(
                strMgr.getString("target.cant_be_null", name.toString()));
        }
    }

    protected void checkTokens(String[] tokens, int minLen)
    {
        checkArg(tokens, name);
        if (tokens.length < minLen)
        {
            throw new IllegalArgumentException(
                strMgr.getString("target.min_token_length", "" + minLen));
        }
    }
}
